/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.Internal;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.core.util.LimitedLogger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class TooltipRenderer {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final LimitedLogger LIMITED_LOGGER = new LimitedLogger(LOGGER, Duration.ofSeconds(30L));

    private TooltipRenderer() {
    }

    public static void drawHoveringText(PoseStack poseStack, List<Component> textLines, int x, int y) {
        Minecraft minecraft = Minecraft.m_91087_();
        Screen screen = minecraft.f_91080_;
        if (screen == null) {
            return;
        }
        Font font = minecraft.f_91062_;
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        try {
            renderHelper.renderTooltip(screen, poseStack, textLines, Optional.empty(), x, y, font, ItemStack.f_41583_);
        }
        catch (RuntimeException e) {
            String stringTooltip = TooltipRenderer.getTooltipDebugString(textLines, "\n");
            String message = "Failed to render tooltip:\n" + stringTooltip;
            LIMITED_LOGGER.log(Level.ERROR, message, message, stringTooltip, e);
        }
    }

    public static <T> void drawHoveringText(PoseStack poseStack, List<Component> textLines, int x, int y, ITypedIngredient<T> typedIngredient, IIngredientManager ingredientManager) {
        IIngredientType<T> ingredientType = typedIngredient.getType();
        IIngredientRenderer<T> ingredientRenderer = ingredientManager.getIngredientRenderer(ingredientType);
        TooltipRenderer.drawHoveringText(poseStack, textLines, x, y, typedIngredient, ingredientRenderer);
    }

    public static <T> void drawHoveringText(PoseStack poseStack, List<Component> textLines, int x, int y, ITypedIngredient<T> typedIngredient, IIngredientRenderer<T> ingredientRenderer) {
        Minecraft minecraft = Minecraft.m_91087_();
        T ingredient = typedIngredient.getIngredient();
        Font font = ingredientRenderer.getFontRenderer(minecraft, ingredient);
        TooltipRenderer.drawHoveringText(poseStack, textLines, x, y, typedIngredient, font);
    }

    private static <T> void drawHoveringText(PoseStack poseStack, List<Component> textLines, int x, int y, ITypedIngredient<T> typedIngredient, Font font) {
        Minecraft minecraft = Minecraft.m_91087_();
        Screen screen = minecraft.f_91080_;
        if (screen == null) {
            return;
        }
        ItemStack itemStack = typedIngredient.getItemStack().orElse(ItemStack.f_41583_);
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        try {
            Optional tooltipImage = itemStack.m_150921_();
            renderHelper.renderTooltip(screen, poseStack, textLines, tooltipImage, x, y, font, itemStack);
        }
        catch (RuntimeException e) {
            T ingredient = typedIngredient.getIngredient();
            IIngredientType<T> type = typedIngredient.getType();
            IIngredientManager ingredientManager = Internal.getIngredientManager();
            String ingredientInfo = ErrorUtil.getIngredientInfo(ingredient, type, ingredientManager);
            String stringTooltip = TooltipRenderer.getTooltipDebugString(textLines, "\n");
            String message = String.format("Failed to render tooltip for ingredient %s:\n%s", ingredientInfo, stringTooltip);
            LIMITED_LOGGER.log(Level.ERROR, message, message, e);
        }
    }

    private static String getTooltipDebugString(List<Component> textLines, String joinDelimiter) {
        return textLines.stream().map(Component::m_6879_).map(MutableComponent::toString).collect(Collectors.joining(joinDelimiter));
    }
}

