/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.mojang.blaze3d.vertex.PoseStack;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferManager;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.transfer.RecipeTransferErrorInternal;
import mezz.jei.common.transfer.RecipeTransferUtil;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.input.UserInput;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public class RecipeTransferButton
extends GuiIconToggleButton {
    private final IRecipeLayoutDrawable<?> recipeLayout;
    private final Runnable onClose;
    @Nullable
    private IRecipeTransferError recipeTransferError;
    @Nullable
    private AbstractContainerMenu parentContainer;
    @Nullable
    private Player player;

    public static RecipeTransferButton create(IRecipeLayoutDrawable<?> recipeLayout, Runnable onClose) {
        Rect2i buttonArea = recipeLayout.getRecipeTransferButtonArea();
        Rect2i layoutArea = recipeLayout.getRect();
        buttonArea.m_173047_(buttonArea.m_110085_() + layoutArea.m_110085_());
        buttonArea.m_173054_(buttonArea.m_110086_() + layoutArea.m_110086_());
        Textures textures = Internal.getTextures();
        IDrawableStatic icon = textures.getRecipeTransfer();
        RecipeTransferButton transferButton = new RecipeTransferButton(icon, recipeLayout, onClose);
        transferButton.updateBounds(buttonArea);
        return transferButton;
    }

    private RecipeTransferButton(IDrawable icon, IRecipeLayoutDrawable<?> recipeLayout, Runnable onClose) {
        super(icon, icon);
        this.recipeLayout = recipeLayout;
        this.onClose = onClose;
    }

    public void update(@Nullable AbstractContainerMenu parentContainer, @Nullable Player player) {
        this.player = player;
        this.parentContainer = parentContainer;
        if (parentContainer != null && player != null) {
            IRecipeTransferManager recipeTransferManager = Internal.getJeiRuntime().getRecipeTransferManager();
            this.recipeTransferError = RecipeTransferUtil.getTransferRecipeError(recipeTransferManager, parentContainer, this.recipeLayout, player).orElse(null);
        } else {
            this.recipeTransferError = RecipeTransferErrorInternal.INSTANCE;
        }
        if (this.recipeTransferError == null || this.recipeTransferError.getType().allowsTransfer) {
            this.button.f_93623_ = true;
            this.button.f_93624_ = true;
        } else {
            this.button.f_93623_ = false;
            IRecipeTransferError.Type type = this.recipeTransferError.getType();
            this.button.f_93624_ = type == IRecipeTransferError.Type.USER_FACING;
        }
    }

    @Override
    protected boolean onMouseClicked(UserInput input) {
        if (!input.isSimulate()) {
            IRecipeTransferManager recipeTransferManager = Internal.getJeiRuntime().getRecipeTransferManager();
            boolean maxTransfer = Screen.m_96638_();
            if (this.parentContainer != null && this.player != null && RecipeTransferUtil.transferRecipe(recipeTransferManager, this.parentContainer, this.recipeLayout, this.player, maxTransfer)) {
                this.onClose.run();
            }
        }
        return true;
    }

    @Override
    protected void getTooltips(JeiTooltip tooltip) {
        if (this.recipeTransferError == null) {
            MutableComponent tooltipTransfer = Component.m_237115_((String)"jei.tooltip.transfer");
            tooltip.add((Component)tooltipTransfer);
        } else {
            this.recipeTransferError.getTooltip(tooltip);
        }
    }

    @Override
    protected boolean isIconToggledOn() {
        return false;
    }

    @Override
    public void draw(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        super.draw(poseStack, mouseX, mouseY, partialTicks);
        IRecipeTransferError recipeTransferError = this.recipeTransferError;
        if (recipeTransferError != null) {
            if (recipeTransferError.getType() == IRecipeTransferError.Type.COSMETIC) {
                GuiComponent.m_93172_((PoseStack)poseStack, (int)this.button.getX(), (int)this.button.getY(), (int)(this.button.getX() + this.button.m_5711_()), (int)(this.button.getY() + this.button.m_93694_()), (int)recipeTransferError.getButtonHighlightColor());
            }
            if (this.isMouseOver(mouseX, mouseY)) {
                IRecipeSlotsView recipeSlotsView = this.recipeLayout.getRecipeSlotsView();
                Rect2i recipeRect = this.recipeLayout.getRect();
                recipeTransferError.showError(poseStack, mouseX, mouseY, recipeSlotsView, recipeRect.m_110085_(), recipeRect.m_110086_());
            }
        }
    }
}

