/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.color;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.library.color.ColorThief;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class ColorGetter {
    private static final Logger LOGGER = LogManager.getLogger();

    public List<Integer> getColors(ItemStack itemStack, int colorCount) {
        try {
            return this.unsafeGetColors(itemStack, colorCount);
        }
        catch (LinkageError | RuntimeException e) {
            String itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
            LOGGER.debug("Failed to get color name for {}", (Object)itemStackInfo, (Object)e);
            return Collections.emptyList();
        }
    }

    private List<Integer> unsafeGetColors(ItemStack itemStack, int colorCount) {
        Item item = itemStack.m_41720_();
        if (itemStack.m_41619_()) {
            return Collections.emptyList();
        }
        if (item instanceof BlockItem) {
            BlockItem itemBlock = (BlockItem)item;
            Block block = itemBlock.m_40614_();
            if (block == null) {
                return Collections.emptyList();
            }
            return this.getBlockColors(block, colorCount);
        }
        return this.getItemColors(itemStack, colorCount);
    }

    private List<Integer> getItemColors(ItemStack itemStack, int colorCount) {
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        ItemColors itemColors = renderHelper.getItemColors();
        int renderColor = itemColors.m_92676_(itemStack, 0);
        TextureAtlasSprite textureAtlasSprite = ColorGetter.getTextureAtlasSprite(itemStack);
        if (textureAtlasSprite == null) {
            return Collections.emptyList();
        }
        return this.getColors(textureAtlasSprite, renderColor, colorCount);
    }

    private List<Integer> getBlockColors(Block block, int colorCount) {
        BlockState blockState = block.m_49966_();
        BlockColors blockColors = Minecraft.m_91087_().m_91298_();
        int renderColor = blockColors.m_92577_(blockState, null, null, 0);
        TextureAtlasSprite textureAtlasSprite = ColorGetter.getTextureAtlasSprite(blockState);
        if (textureAtlasSprite == null) {
            return Collections.emptyList();
        }
        return this.getColors(textureAtlasSprite, renderColor, colorCount);
    }

    public List<Integer> getColors(TextureAtlasSprite textureAtlasSprite, int renderColor, int colorCount) {
        if (colorCount <= 0) {
            return Collections.emptyList();
        }
        return ColorGetter.getNativeImage(textureAtlasSprite).map(bufferedImage -> {
            int[][] palette;
            ArrayList<Integer> colors = new ArrayList<Integer>(colorCount);
            for (int[] colorInt : palette = ColorThief.getPalette(bufferedImage, colorCount, 2, false)) {
                int red = (int)((float)(colorInt[0] - 1) * (float)(renderColor >> 16 & 0xFF) / 255.0f);
                int green = (int)((float)(colorInt[1] - 1) * (float)(renderColor >> 8 & 0xFF) / 255.0f);
                int blue = (int)((float)(colorInt[2] - 1) * (float)(renderColor & 0xFF) / 255.0f);
                red = Mth.m_14045_((int)red, (int)0, (int)255);
                green = Mth.m_14045_((int)green, (int)0, (int)255);
                blue = Mth.m_14045_((int)blue, (int)0, (int)255);
                int color = 0xFF000000 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
                colors.add(color);
            }
            return colors;
        }).orElseGet(Collections::emptyList);
    }

    private static Optional<NativeImage> getNativeImage(TextureAtlasSprite textureAtlasSprite) {
        int iconWidth = textureAtlasSprite.m_118405_();
        int iconHeight = textureAtlasSprite.m_118408_();
        if (iconWidth <= 0 || iconHeight <= 0) {
            return Optional.empty();
        }
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        return renderHelper.getMainImage(textureAtlasSprite);
    }

    @Nullable
    private static TextureAtlasSprite getTextureAtlasSprite(BlockState blockState) {
        Minecraft minecraft = Minecraft.m_91087_();
        BlockRenderDispatcher blockRendererDispatcher = minecraft.m_91289_();
        BlockModelShaper blockModelShapes = blockRendererDispatcher.m_110907_();
        BakedModel blockModel = blockModelShapes.m_110893_(blockState);
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        TextureAtlasSprite textureAtlasSprite = renderHelper.getParticleIcon(blockModel);
        if (textureAtlasSprite instanceof MissingTextureAtlasSprite) {
            return null;
        }
        return textureAtlasSprite;
    }

    @Nullable
    private static TextureAtlasSprite getTextureAtlasSprite(ItemStack itemStack) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        ItemModelShaper itemModelMesher = itemRenderer.m_115103_();
        BakedModel itemModel = itemModelMesher.m_109406_(itemStack);
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        TextureAtlasSprite particleTexture = renderHelper.getParticleIcon(itemModel);
        if (particleTexture instanceof MissingTextureAtlasSprite) {
            return null;
        }
        return particleTexture;
    }
}

