/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.entity;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.InteractGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.ITeleporter;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.api.item.IDisableable;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.entity.Trades;
import ovh.corail.tombstone.entity.ai.LookAtTradingPlayerGoal;
import ovh.corail.tombstone.entity.ai.TradeWithPlayerGoal;
import ovh.corail.tombstone.event.EventFactory;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;

public abstract class AbstractMerchant
extends PathfinderMob
implements Merchant {
    private static final EntityDataAccessor<Byte> TRADE_LEVEL = SynchedEntityData.m_135353_(AbstractMerchant.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> TRADE_XP = SynchedEntityData.m_135353_(AbstractMerchant.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    protected Player tradingPlayer;
    @Nullable
    protected MerchantOffers offers;
    protected long lastRestockGameTime = -1L;
    private static final int UPDATE_VERSION = 7;

    protected AbstractMerchant(EntityType<? extends AbstractMerchant> merchant, Level level) {
        super(merchant, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TRADE_LEVEL, (Object)1);
        this.f_19804_.m_135372_(TRADE_XP, (Object)0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, new TradeWithPlayerGoal<AbstractMerchant>(this));
        this.f_21345_.m_25352_(1, new LookAtTradingPlayerGoal<AbstractMerchant>(this));
        this.f_21345_.m_25352_(9, (Goal)new InteractGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public Level m_9236_() {
        return this.f_19853_;
    }

    public void m_7189_(@Nullable Player player) {
        this.tradingPlayer = player;
    }

    @Nullable
    public Player m_7962_() {
        return this.tradingPlayer;
    }

    public MerchantOffers m_6616_() {
        if (this.offers == null) {
            this.initTrades();
        }
        return this.offers;
    }

    private void initTrades() {
        this.offers = new MerchantOffers();
        int tradeLevel = this.getTradeLevel();
        this.addBasicTrades(TradeType.COMMON, tradeLevel + 4);
        if (tradeLevel > 1) {
            this.addBasicTrades(TradeType.UNCOMMON, tradeLevel + 2);
        }
        if (tradeLevel > 3) {
            this.addBasicTrades(TradeType.RARE, tradeLevel);
        }
        if (TimeHelper.isDateAroundHalloween()) {
            this.addHalloweenTrades(TradeType.COMMON);
            if (tradeLevel > 1) {
                this.addHalloweenTrades(TradeType.UNCOMMON);
            }
            if (tradeLevel > 3) {
                this.addHalloweenTrades(TradeType.RARE);
            }
        } else if (TimeHelper.isDateAroundChristmas()) {
            this.addChristmasTrades(TradeType.COMMON);
            if (tradeLevel > 1) {
                this.addChristmasTrades(TradeType.UNCOMMON);
            }
            if (tradeLevel > 3) {
                this.addChristmasTrades(TradeType.RARE);
            }
        } else if (TimeHelper.isDateAroundEaster()) {
            this.addEasterTrades(TradeType.COMMON);
            if (tradeLevel > 1) {
                this.addEasterTrades(TradeType.UNCOMMON);
            }
            if (tradeLevel > 3) {
                this.addEasterTrades(TradeType.RARE);
            }
        }
        EventFactory.onInitGraveGuardianOffers(this);
    }

    private void addBasicTrades(TradeType tradeType, int toAdd) {
        Optional.of(tradeType.getBasicTrades()).filter(trades -> ((VillagerTrades.ItemListing[])trades).length > 0).ifPresent(trades -> this.addTrades((VillagerTrades.ItemListing[])trades, toAdd));
    }

    private void addHalloweenTrades(TradeType tradeType) {
        Optional.of(tradeType.getHalloweenTrades()).filter(trades -> ((VillagerTrades.ItemListing[])trades).length > 0).ifPresent(trades -> this.addTrades((VillagerTrades.ItemListing[])trades, ((VillagerTrades.ItemListing[])trades).length));
    }

    private void addChristmasTrades(TradeType tradeType) {
        Optional.of(tradeType.getChristmasTrades()).filter(trades -> ((VillagerTrades.ItemListing[])trades).length > 0).ifPresent(trades -> this.addTrades((VillagerTrades.ItemListing[])trades, ((VillagerTrades.ItemListing[])trades).length));
    }

    private void addEasterTrades(TradeType tradeType) {
        Optional.of(tradeType.getEasterTrades()).filter(trades -> ((VillagerTrades.ItemListing[])trades).length > 0).ifPresent(trades -> this.addTrades((VillagerTrades.ItemListing[])trades, ((VillagerTrades.ItemListing[])trades).length));
    }

    private void addTrades(VillagerTrades.ItemListing[] trades, int toAdd) {
        if (toAdd >= trades.length) {
            Arrays.stream(trades).map(trade -> trade.m_213663_((Entity)this, this.f_19796_)).filter(Objects::nonNull).forEach(arg_0 -> this.m_6616_().add(arg_0));
        } else {
            List ids = IntStream.range(0, trades.length).boxed().collect(Collectors.toList());
            Collections.shuffle(ids, Helper.RANDOM);
            Iterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                MerchantOffer offer = trades[id].m_213663_((Entity)this, this.f_19796_);
                if (offer == null) continue;
                this.m_6616_().add((Object)offer);
                if (--toAdd > 0) continue;
                break;
            }
        }
    }

    public void m_6255_(MerchantOffers offers) {
        this.offers = offers;
    }

    public void m_6621_(int xp) {
        this.setVillagerXp(xp);
        this.increaseLevel(0);
    }

    public void m_7713_(ItemStack stack) {
        if (!this.f_19853_.f_46443_ && this.f_21363_ > -this.m_8100_() + 20) {
            this.f_21363_ = -this.m_8100_();
            this.m_5496_(stack.m_41619_() ? SoundEvents.f_12382_ : SoundEvents.f_12383_, this.m_6121_(), this.m_6100_());
        }
    }

    public void m_6996_(MerchantOffer offer) {
        offer.m_45374_();
        if (EntityHelper.isValidServerPlayer(this.tradingPlayer)) {
            ServerPlayer player = (ServerPlayer)this.tradingPlayer;
            assert (player != null);
            ModTriggers.TRADE_GRAVE_GUARDIAN.trigger(player);
            boolean isFirstSlot = offer.m_45352_().m_150930_((Item)ModItems.lollipop);
            if (isFirstSlot || offer.m_45364_().m_150930_((Item)ModItems.lollipop)) {
                ModTriggers.TRADE_LOLLIPOP.trigger(player, (isFirstSlot ? offer.m_45352_() : offer.m_45364_()).m_41613_());
                if (offer.m_45368_().m_150930_((Item)ModItems.essence_of_undeath)) {
                    ModTriggers.TRADE_LOLLIPOP_FOR_ESSENCE.trigger(player);
                }
            }
            if (offer.m_45368_().m_150930_((Item)ModItems.rabbit_mask)) {
                ModTriggers.TRADE_EASTER_MASK.trigger(player);
            }
        }
        this.f_21363_ = -this.m_8100_();
        boolean isLevelUp = this.increaseLevel(offer.m_45379_());
        if (offer.m_45383_()) {
            this.f_19853_.m_7967_((Entity)new ExperienceOrb(this.f_19853_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), (isLevelUp ? 20 : 0) + this.f_19796_.m_188503_(offer.m_45379_()) + offer.m_45379_()));
        }
    }

    private boolean increaseLevel(int offerXp) {
        int traderLevel = this.getTradeLevel();
        this.setVillagerXp(this.m_7809_() + offerXp);
        if (traderLevel < 5 && this.m_7809_() >= VillagerData.m_35577_((int)traderLevel)) {
            this.setTradeLevel(traderLevel + 1);
            this.initTrades();
            Optional.ofNullable(this.m_7962_()).ifPresent(player -> player.m_7662_(player.f_36096_.f_38840_, this.m_6616_(), traderLevel + 1, this.m_7809_(), this.m_7826_(), this.m_7862_()));
            return true;
        }
        return false;
    }

    @Nullable
    public Entity changeDimension(ServerLevel level, ITeleporter teleporter) {
        this.m_7189_(null);
        return super.changeDimension(level, teleporter);
    }

    public void m_6667_(DamageSource damageSource) {
        super.m_6667_(damageSource);
        this.m_7189_(null);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.m_6084_() && this.tradingPlayer == null) {
            if (hand == InteractionHand.MAIN_HAND && EntityHelper.isValidServerPlayer(player)) {
                ModTriggers.TALK_GRAVE_GUARDIAN.trigger((ServerPlayer)player);
            }
            if (!(this.f_19853_.f_46443_ || this.m_6616_().isEmpty() || EntityHelper.targetAnEnemy((LivingEntity)this))) {
                this.m_7189_(player);
                this.m_45301_(player, this.m_5446_(), this.getTradeLevel());
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public int m_7809_() {
        return (Integer)this.f_19804_.m_135370_(TRADE_XP);
    }

    public void setVillagerXp(int tradeXp) {
        this.f_19804_.m_135381_(TRADE_XP, (Object)tradeXp);
    }

    public int getTradeLevel() {
        return (Byte)this.f_19804_.m_135370_(TRADE_LEVEL) & 0xFF;
    }

    public void setTradeLevel(int tradeLevel) {
        this.f_19804_.m_135381_(TRADE_LEVEL, (Object)((byte)tradeLevel));
    }

    public boolean m_7826_() {
        return true;
    }

    public boolean m_7862_() {
        return true;
    }

    public boolean m_183595_() {
        return this.f_19853_.f_46443_;
    }

    public void restock() {
        for (MerchantOffer offer : this.m_6616_()) {
            boolean hasImpregnatedDiamondA = offer.m_45352_().m_150930_((Item)ModItems.impregnated_diamond);
            boolean hasImpregnatedDiamondB = offer.m_45364_().m_150930_((Item)ModItems.impregnated_diamond);
            if ((hasImpregnatedDiamondA || hasImpregnatedDiamondB) && (offer.m_45371_() > 0 || this.f_19796_.m_188503_(31) == 0)) {
                if (hasImpregnatedDiamondA) {
                    ModItems.impregnated_diamond.withRandomImpregnation(offer.m_45352_());
                }
                if (hasImpregnatedDiamondB) {
                    ModItems.impregnated_diamond.withRandomImpregnation(offer.m_45364_());
                }
            }
            if (offer.m_45352_().m_150930_((Item)ModItems.lollipop)) {
                if (this.f_19796_.m_188503_(31) == 0) {
                    ModItems.lollipop.resetColor(offer.m_45352_());
                }
            } else if (offer.m_45352_().m_150930_((Item)ModItems.easter_egg) && this.f_19796_.m_188503_(31) == 0) {
                ModItems.easter_egg.resetColor(offer.m_45352_());
            }
            offer.m_45372_();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.m_5776_() && this.tradingPlayer == null && this.m_7862_()) {
            long worldTicks = TimeHelper.worldTicks(this.f_19853_);
            if (this.lastRestockGameTime < 0L || this.lastRestockGameTime > worldTicks) {
                this.lastRestockGameTime = worldTicks;
            } else if (worldTicks - this.lastRestockGameTime >= (long)TimeHelper.tickFromMinute(Math.max(1, (Integer)ConfigTombstone.decorative_grave.restockTimeGraveGuardian.get()))) {
                this.lastRestockGameTime = worldTicks;
                this.restock();
            }
        }
    }

    public SoundEvent m_7596_() {
        return SoundEvents.f_144211_;
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128376_("special_event", (short)TimeHelper.getSpecialEvent().ordinal());
        compoundTag.m_128376_("update_version", (short)7);
        MerchantOffers offers = this.m_6616_();
        if (!offers.isEmpty()) {
            compoundTag.m_128365_("Offers", (Tag)offers.m_45388_());
        }
        compoundTag.m_128344_("trade_level", ((Byte)this.f_19804_.m_135370_(TRADE_LEVEL)).byteValue());
        compoundTag.m_128405_("trade_xp", this.m_7809_());
        compoundTag.m_128356_("last_restock", this.lastRestockGameTime);
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.loadOffers(compoundTag);
        if (compoundTag.m_128425_("trade_level", 1)) {
            this.setTradeLevel(compoundTag.m_128445_("trade_level") & 0xFF);
        }
        if (compoundTag.m_128425_("trade_xp", 3)) {
            this.setVillagerXp(compoundTag.m_128451_("trade_xp"));
        }
        if (compoundTag.m_128425_("last_restock", 4)) {
            this.lastRestockGameTime = compoundTag.m_128454_("last_restock");
        }
    }

    private boolean specialEventRequireChangeTrade(CompoundTag compound) {
        if (!compound.m_128425_("special_event", 2)) {
            return false;
        }
        if (TimeHelper.isAprilFoolsDay()) {
            return false;
        }
        short specialEventId = compound.m_128448_("special_event");
        if (specialEventId == 1) {
            return false;
        }
        return TimeHelper.getSpecialEvent().ordinal() != specialEventId;
    }

    private void loadOffers(CompoundTag compound) {
        if (this.specialEventRequireChangeTrade(compound)) {
            this.offers = null;
        } else if (compound.m_128425_("update_version", 2) && 7 != compound.m_128448_("update_version")) {
            this.offers = null;
        } else if (compound.m_128425_("Offers", 10)) {
            this.offers = new MerchantOffers(compound.m_128469_("Offers"));
            for (MerchantOffer offer : this.offers) {
                IDisableable disableable;
                ItemStack buy2;
                Item item;
                IDisableable disableable2;
                ItemStack buy1 = offer.m_45352_();
                Item item2 = buy1.m_41720_();
                if (item2 instanceof IDisableable && !(disableable2 = (IDisableable)item2).isEnabled()) {
                    this.offers = null;
                    return;
                }
                if (buy1.m_150930_((Item)ModItems.impregnated_diamond) && ModItems.impregnated_diamond.getEntityType(buy1).isEmpty()) {
                    ModItems.impregnated_diamond.withRandomImpregnation(buy1);
                }
                if ((item = (buy2 = offer.m_45364_()).m_41720_()) instanceof IDisableable && !(disableable = (IDisableable)item).isEnabled()) {
                    this.offers = null;
                    return;
                }
                if (!buy2.m_150930_((Item)ModItems.impregnated_diamond) || !ModItems.impregnated_diamond.getEntityType(buy2).isEmpty()) continue;
                ModItems.impregnated_diamond.withRandomImpregnation(buy2);
            }
        }
    }

    private static enum TradeType {
        COMMON,
        UNCOMMON,
        RARE;


        private VillagerTrades.ItemListing[] getBasicTrades() {
            return (VillagerTrades.ItemListing[])Trades.TRADES.get(this.ordinal() + 1);
        }

        private VillagerTrades.ItemListing[] getHalloweenTrades() {
            return (VillagerTrades.ItemListing[])Trades.HALLOWEEN_TRADES.get(this.ordinal() + 1);
        }

        private VillagerTrades.ItemListing[] getChristmasTrades() {
            return (VillagerTrades.ItemListing[])Trades.CHRISTMAS_TRADES.get(this.ordinal() + 1);
        }

        private VillagerTrades.ItemListing[] getEasterTrades() {
            return (VillagerTrades.ItemListing[])Trades.EASTER_TRADES.get(this.ordinal() + 1);
        }
    }
}

