/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.damagesource.DamageSource;

public enum DamageCategory implements StringRepresentable
{
    SUFFOCATION,
    BURN,
    LIGHTNING,
    FALL,
    COLD,
    DARKNESS,
    LIGHT,
    UNKNOWN;

    private static final Map<String, DamageCategory> DAMAGE_STRINGS;
    private final String name = this.name().toLowerCase(Locale.US);

    public boolean is(DamageSource s) {
        return DamageCategory.of(s) == this;
    }

    public static DamageCategory of(DamageSource s) {
        if (s.m_19384_()) {
            return BURN;
        }
        if (s == DamageSource.f_19306_) {
            return LIGHTNING;
        }
        if (s == DamageSource.f_146701_) {
            return COLD;
        }
        if (s == DamageSource.f_19312_ || s == DamageSource.f_19310_ || s == DamageSource.f_19311_ || s == DamageSource.f_19313_) {
            return SUFFOCATION;
        }
        if (s.m_146707_() || s == DamageSource.f_19316_) {
            return FALL;
        }
        if (s == DamageSource.f_19320_ || s == DamageSource.f_19323_) {
            return DARKNESS;
        }
        String type = s.m_19385_().toLowerCase(Locale.US);
        return DAMAGE_STRINGS.computeIfAbsent(type, DamageCategory::fromString);
    }

    private static DamageCategory fromString(String type) {
        if (DamageCategory.contains(type, "lightning", "electr", "discharg")) {
            return LIGHTNING;
        }
        if (DamageCategory.contains(type, "spore", "poison")) {
            return SUFFOCATION;
        }
        if (DamageCategory.contains(type, "lich", "haunt", "darkness", "spectr")) {
            return DARKNESS;
        }
        if (type.startsWith("ice") || DamageCategory.contains(type, "chill", "frost", "froz", "freez", "snow", "cold")) {
            return COLD;
        }
        return UNKNOWN;
    }

    private static boolean contains(String type, String ... containWords) {
        return Arrays.stream(containWords).anyMatch(type::contains);
    }

    public String m_7912_() {
        return this.name;
    }

    static {
        DAMAGE_STRINGS = new HashMap<String, DamageCategory>();
    }
}

