/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.loot.IDelayedNBTLoot;
import ovh.corail.tombstone.registry.ModItems;

public class ItemEasterEgg
extends ItemGeneric
implements IDelayedNBTLoot {
    public ItemEasterEgg() {
        super("easter_egg", ItemEasterEgg.getBuilder().m_41489_(new FoodProperties.Builder().m_38760_(2).m_38758_(2.0f).m_38766_().m_38765_().m_38767_()));
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Level level, List<Component> tooltip) {
        tooltip.add((Component)Component.m_237115_((String)(this.m_5671_(stack) + ".desc")).m_6270_(StyleType.TOOLTIP_DESC));
        super.addTooltipInfo(stack, level, tooltip);
    }

    @Override
    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
    }

    public Component m_7626_(ItemStack stack) {
        return super.m_7626_(stack).m_6879_().m_6270_(StyleType.MESSAGE_SPECIAL);
    }

    public int getColor(ItemStack stack, int tintIndex) {
        if (stack.m_150930_((Item)this) && tintIndex == 0) {
            short ordinal;
            return 0xFF000000 | ((ordinal = NBTStackHelper.getShort((ItemStack)stack, (String)"model_color", (short)-1)) >= 0 && ordinal < ModelColor.values().length ? ModelColor.values()[ordinal] : ModelColor.values()[0]).color;
        }
        return -1;
    }

    public ItemStack setColor(ItemStack stack, ModelColor modelColor) {
        if (stack.m_150930_((Item)this)) {
            NBTStackHelper.setShort(stack, "model_color", (short)modelColor.ordinal());
        }
        return stack;
    }

    public ItemStack getRandomItemStack() {
        return this.getRandomItemStack(1);
    }

    public ItemStack getRandomItemStack(int count) {
        return this.resetColor(new ItemStack((ItemLike)this, count));
    }

    public ItemStack resetColor(ItemStack stack) {
        return this.setColor(stack, ModelColor.getRandom());
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.EAT;
    }

    @Override
    public ItemStack onDelayedLoot(ItemStack stack, CompoundTag tag, LootContext context) {
        return this.resetColor(stack);
    }

    public static enum ModelColor {
        PURPLE(5584316),
        GREEN(9034633),
        PINK(0xFF29FF),
        YELLOW(0xFCFF00),
        RED(0xFF2929),
        BLUE(0x2929FF);

        private final int color;

        private ModelColor(int color) {
            this.color = color;
        }

        public static ModelColor getRandom() {
            return ModelColor.values()[Helper.RANDOM.nextInt(ModelColor.values().length)];
        }

        public ItemStack asItemStack() {
            return ModItems.easter_egg.setColor(new ItemStack((ItemLike)ModItems.easter_egg), this);
        }

        public ItemStack asItemStack(int count) {
            return ModItems.easter_egg.setColor(new ItemStack((ItemLike)ModItems.easter_egg, count), this);
        }
    }
}

