/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.combine.CombineCraft;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.item.ICombineCraft;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTags;
import ovh.corail.tombstone.registry.ModTriggers;
import ovh.corail.tombstone.tileentity.BlockEntityPlayerGrave;

public class ItemGraveKey
extends ItemGraveMagic
implements ICombineCraft {
    private TooltipComponent tooltip;
    private static final String OWNER_ID_NBT_UUID = "owner_id";
    private static final String TOMB_POS_NBT_LOCATION = "tomb_pos";

    public ItemGraveKey() {
        super("grave_key", () -> SharedConfigTombstone.allowed_magic_items.allowGraveKey.get());
        this.withSoulboundInfo().withCombineInfo();
    }

    @Override
    public void m_6787_(CreativeModeTab tab, NonNullList<ItemStack> items) {
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Level level, List<Component> tooltip) {
        String id = this.isEnchanted(stack) ? "2" : "1";
        this.addItemDesc(tooltip, id, new Object[0]);
        this.addItemDesc(tooltip, "3", new Object[0]);
        this.addItemPosition(tooltip, this.getTombPos(stack));
        this.addItemUse(tooltip, id, new Object[0]);
        super.addTooltipInfo(stack, level, tooltip);
    }

    public boolean m_142305_(ItemStack graveKey, ItemStack added, Slot slot, ClickAction action, Player player, SlotAccess slotAccess) {
        CombineCraft combine;
        if (action == ClickAction.SECONDARY && EntityHelper.isValidPlayer(player) && slot.m_150651_(player) && graveKey.m_150930_((Item)this) && (combine = this.getCombination(added)) != null) {
            if (((Boolean)SharedConfigTombstone.magic_item.disableEnchantedGraveKeyRecipe.get()).booleanValue()) {
                ModTombstone.PROXY.addToast(combine.added(), combine.result(), (Component)LangKey.MESSAGE_CRAFT_ENCHANTED_GRAVE_KEY_DISABLED.getText(new Object[0]));
            } else if (this.isEnchanted(graveKey)) {
                ModTombstone.PROXY.addToast(combine.added(), combine.result(), (Component)LangKey.MESSAGE_ENCHANT_ITEM_ALREADY_ENCHANTED.getText(new Object[0]));
            } else {
                boolean isServerSide;
                boolean bl = isServerSide = !player.f_19853_.m_5776_();
                if (isServerSide || player.m_7500_()) {
                    NBTStackHelper.setBoolean(graveKey, "enchant", true);
                    added.m_41774_(1);
                    if (isServerSide) {
                        ModTriggers.COMBINE_IN_INVENTORY.trigger((ServerPlayer)player);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        if (this.tooltip == null) {
            this.tooltip = this.createTooltip();
        }
        return this.isEnchanted(stack) ? Optional.empty() : Optional.of(this.tooltip);
    }

    @Override
    public void addCombinations(List<CombineCraft> combinations) {
        combinations.add(new CombineCraft(ModTags.Items.enchanted_grave_key_ingredients, NBTStackHelper.setBoolean(new ItemStack((ItemLike)this), "enchant", true)));
    }

    public ItemStack createWithInfo(Player player, Location location) {
        ItemStack stack = new ItemStack((ItemLike)this);
        if (!location.isOrigin()) {
            CompoundTag tag = stack.m_41784_();
            NBTStackHelper.setUUID(tag, OWNER_ID_NBT_UUID, player.m_36316_().getId());
            NBTStackHelper.setLocation(tag, TOMB_POS_NBT_LOCATION, location);
        }
        return stack;
    }

    public Optional<UUID> getOwnerId(ItemStack stack) {
        return stack.m_150930_((Item)this) ? NBTStackHelper.getUUID(stack, OWNER_ID_NBT_UUID) : Optional.empty();
    }

    public Location getTombPos(ItemStack stack) {
        return stack.m_150930_((Item)this) ? NBTStackHelper.getLocation(stack, TOMB_POS_NBT_LOCATION) : Location.ORIGIN;
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!level.m_5776_() && EntityHelper.isValidPlayer(entity) && entity.m_6084_() && stack.m_150930_((Item)this)) {
            double range;
            ServerPlayer player = (ServerPlayer)entity;
            Location location = this.getTombPos(stack);
            boolean isBadKey = location.isOrigin();
            if (!isBadKey && location.isSameDimension(level) && (range = player.m_20275_((double)location.getPos().m_123341_(), (double)location.getPos().m_123342_(), (double)location.getPos().m_123343_())) < 43000.0 && Helper.RANDOM.nextInt(range >= 100.0 ? 2400 : (isSelected ? 100 : 300)) == 0 && level.m_46749_(location.getPos())) {
                Optional<BlockEntityPlayerGrave> res = Helper.getPlayerGrave(level, location.getPos());
                boolean bl = isBadKey = res.isEmpty() || this.getOwnerId(stack).map(id -> !id.equals(((BlockEntityPlayerGrave)((Object)((Object)res.get()))).getOwnerId())).orElse(false) != false;
            }
            if (isBadKey) {
                stack.m_41774_(1);
                player.f_36095_.m_38946_();
            }
        }
    }

    public boolean removeKeyForGraveInInventory(Player player, BlockEntityPlayerGrave grave) {
        assert (grave.m_58904_() != null);
        return InventoryHelper.removeFirstInInventory(player, stack -> stack.m_150930_((Item)this) && this.getTombPos((ItemStack)stack).equals(new Location(grave.m_58899_(), grave.m_58904_())) && this.getOwnerId((ItemStack)stack).map(id -> id.equals(grave.getOwnerId())).orElse(false) != false);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.m_150930_((Item)this) && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        if (stack.m_150930_((Item)this)) {
            NBTStackHelper.setBoolean(stack, "enchant", true);
            return ISoulConsumer.ConsumeResult.success(1);
        }
        return ISoulConsumer.ConsumeResult.fail();
    }

    @Override
    protected boolean doEffects(ServerLevel level, ServerPlayer player, ItemStack stack, @Nullable LivingEntity target) {
        Location location = this.getTombPos(stack);
        if (location.isOrigin()) {
            LangKey.MESSAGE_INVALID_LOCATION.sendMessage((Player)player, new Object[0]);
            return false;
        }
        if (!((Boolean)ConfigTombstone.general.teleportDim.get()).booleanValue() && !location.isSameDimension((Level)level)) {
            LangKey.MESSAGE_TELEPORT_SAME_DIMENSION.sendMessage((Player)player, new Object[0]);
            return false;
        }
        ServerLevel targetWorld = level.m_7654_().m_129880_(location.dim);
        if (!Helper.isValidPos((Level)targetWorld, location.getPos())) {
            LangKey.MESSAGE_INVALID_LOCATION.sendMessage((Player)player, new Object[0]);
            return false;
        }
        Location spawnPos = new SpawnHelper(targetWorld, location.move(Direction.UP, 1).getPos()).findSpawnPlace();
        if (spawnPos.isOrigin()) {
            LangKey.MESSAGE_NO_SPAWN.sendMessage((Player)player, new Object[0]);
            return false;
        }
        NBTStackHelper.setBoolean(stack, "enchant", false);
        CallbackHandler.addFastCallback(() -> {
            Player newPlayer = (Player)Helper.teleport(player, spawnPos, targetWorld);
            if (((Boolean)ConfigTombstone.player_death.nerfGhostlyShapeTeleportWithKey.get()).booleanValue()) {
                EffectHelper.capDuration((LivingEntity)newPlayer, ModEffects.ghostly_shape, 200);
            }
            LangKey.MESSAGE_TELEPORT_SUCCESS.sendMessage(newPlayer, new Object[0]);
            ModTriggers.TELEPORT_TO_GRAVE.trigger(player);
        });
        return true;
    }

    @Override
    protected boolean canConsumeOnUse() {
        return false;
    }

    @Override
    protected int getCastingCooldown() {
        return 0;
    }

    @Override
    protected int getUseMax() {
        return 1;
    }

    public void reenchantOnDeath(Player player, ItemStack key) {
        if (key.m_150930_((Item)this)) {
            int chanceEnchantedKey;
            int n = chanceEnchantedKey = (Boolean)SharedConfigTombstone.magic_item.alwaysEnchantGraveKey.get() != false ? 100 : EntityHelper.getPerkLevelWithBonus(player, ModPerks.jailer) * 20;
            if (chanceEnchantedKey >= 100 || Helper.RANDOM.nextInt(100) < chanceEnchantedKey) {
                NBTStackHelper.setBoolean(key, "enchant", true);
            }
        }
    }

    @Override
    protected boolean canBlockInteractFirst(Level level, BlockPos pos, ItemStack stack) {
        return super.canBlockInteractFirst(level, pos, stack) || ModBlocks.isPlayerGrave(level.m_8055_(pos).m_60734_());
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        if (stack.m_41783_() != null) {
            CompoundTag tag = stack.m_41783_().m_6426_();
            tag.m_128473_(OWNER_ID_NBT_UUID);
            return tag;
        }
        return null;
    }
}

