/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.player_mobs.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import se.gory_moon.player_mobs.client.render.PlayerMobCapeLayer;
import se.gory_moon.player_mobs.client.render.PlayerMobDeadmau5EarsLayer;
import se.gory_moon.player_mobs.entity.PlayerMobEntity;
import se.gory_moon.player_mobs.utils.TextureUtils;

public class PlayerMobRenderer
extends HumanoidMobRenderer<PlayerMobEntity, PlayerModel<PlayerMobEntity>> {
    private final PlayerModel<PlayerMobEntity> steveModel;
    private final PlayerModel<PlayerMobEntity> alexModel;
    private final RenderLayer<PlayerMobEntity, PlayerModel<PlayerMobEntity>> steveArmorModel;
    private final RenderLayer<PlayerMobEntity, PlayerModel<PlayerMobEntity>> alexArmorModel;
    private final int armorLayerIndex;

    public PlayerMobRenderer(EntityRendererProvider.Context context) {
        super(context, (HumanoidModel)new PlayerModel(context.m_174023_(ModelLayers.f_171162_), false), 0.5f);
        this.steveModel = (PlayerModel)this.f_115290_;
        this.alexModel = new PlayerModel(context.m_174023_(ModelLayers.f_171166_), true);
        this.steveArmorModel = new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.m_174023_(ModelLayers.f_171164_)), new HumanoidModel(context.m_174023_(ModelLayers.f_171165_)));
        this.alexArmorModel = new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.m_174023_(ModelLayers.f_171167_)), new HumanoidModel(context.m_174023_(ModelLayers.f_171168_)));
        ArrowLayer arrowLayer = new ArrowLayer(context, (LivingEntityRenderer)this);
        this.m_115326_((RenderLayer)arrowLayer);
        this.armorLayerIndex = this.f_115291_.indexOf(arrowLayer);
        this.m_115326_(new PlayerMobDeadmau5EarsLayer((RenderLayerParent<PlayerMobEntity, PlayerModel<PlayerMobEntity>>)this));
        this.m_115326_(new PlayerMobCapeLayer((RenderLayerParent<PlayerMobEntity, PlayerModel<PlayerMobEntity>>)this));
    }

    public void render(PlayerMobEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        boolean slim = TextureUtils.getPlayerSkinType(pEntity.getProfile()) == TextureUtils.SkinType.SLIM;
        this.f_115290_ = slim ? this.alexModel : this.steveModel;
        this.f_115291_.remove(this.steveArmorModel);
        this.f_115291_.remove(this.alexArmorModel);
        this.f_115291_.add(this.armorLayerIndex, slim ? this.alexArmorModel : this.steveArmorModel);
        ((PlayerModel)this.f_115290_).f_102815_ = HumanoidModel.ArmPose.EMPTY;
        ((PlayerModel)this.f_115290_).f_102816_ = HumanoidModel.ArmPose.EMPTY;
        ItemStack stack = pEntity.m_21205_();
        if (!stack.m_41619_()) {
            if (stack.m_41720_() instanceof CrossbowItem) {
                if (pEntity.isChargingCrossbow()) {
                    this.setHandPose(pEntity, HumanoidModel.ArmPose.CROSSBOW_CHARGE);
                } else {
                    this.setHandPose(pEntity, HumanoidModel.ArmPose.CROSSBOW_HOLD);
                }
            } else if (stack.m_41720_() instanceof BowItem && pEntity.m_5912_()) {
                this.setHandPose(pEntity, HumanoidModel.ArmPose.BOW_AND_ARROW);
            } else {
                this.setHandPose(pEntity, HumanoidModel.ArmPose.ITEM);
            }
        }
        super.m_7392_((Mob)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    private void setHandPose(PlayerMobEntity entity, HumanoidModel.ArmPose pose) {
        if (entity.m_5737_() == HumanoidArm.RIGHT) {
            ((PlayerModel)this.f_115290_).f_102816_ = pose;
        } else {
            ((PlayerModel)this.f_115290_).f_102815_ = pose;
        }
    }

    protected void scale(PlayerMobEntity entity, PoseStack matrix, float partialTickTime) {
        matrix.m_85841_(0.9375f, 0.9375f, 0.9375f);
    }

    public ResourceLocation getTextureLocation(PlayerMobEntity entity) {
        return TextureUtils.getPlayerSkin(entity);
    }
}

