/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.player_mobs.repack.registrate.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.EventBus;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventListenerHelper;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OneTimeEventReceiver<T extends Event>
implements Consumer<T> {
    private static final Logger log;
    @Nullable
    private static final MethodHandle getBusId;
    private final IEventBus bus;
    private final Consumer<? super T> listener;
    private final AtomicBoolean consumed = new AtomicBoolean();
    private static final List<Triple<IEventBus, Object, Class<? extends Event>>> toUnregister;

    public static <T extends Event> void addModListener(Class<? super T> evtClass, Consumer<? super T> listener) {
        OneTimeEventReceiver.addModListener(EventPriority.NORMAL, evtClass, listener);
    }

    public static <T extends Event> void addModListener(EventPriority priority, Class<? super T> evtClass, Consumer<? super T> listener) {
        OneTimeEventReceiver.addListener(FMLJavaModLoadingContext.get().getModEventBus(), priority, evtClass, listener);
    }

    public static <T extends Event> void addForgeListener(Class<? super T> evtClass, Consumer<? super T> listener) {
        OneTimeEventReceiver.addForgeListener(EventPriority.NORMAL, evtClass, listener);
    }

    public static <T extends Event> void addForgeListener(EventPriority priority, Class<? super T> evtClass, Consumer<? super T> listener) {
        OneTimeEventReceiver.addListener(MinecraftForge.EVENT_BUS, priority, evtClass, listener);
    }

    public static <T extends Event> void addListener(IEventBus bus, Class<? super T> evtClass, Consumer<? super T> listener) {
        OneTimeEventReceiver.addListener(bus, EventPriority.NORMAL, evtClass, listener);
    }

    public static <T extends Event> void addListener(IEventBus bus, EventPriority priority, Class<? super T> evtClass, Consumer<? super T> listener) {
        bus.addListener(priority, false, evtClass, new OneTimeEventReceiver<T>(bus, listener));
    }

    @Override
    public void accept(T event) {
        if (this.consumed.compareAndSet(false, true)) {
            this.listener.accept(event);
            OneTimeEventReceiver.unregister(this.bus, (Object)this, event);
        }
    }

    @Deprecated
    public static synchronized void unregister(IEventBus bus, Object listener, Event event) {
        OneTimeEventReceiver.unregister(bus, listener, event.getClass());
    }

    public static synchronized void unregister(IEventBus bus, Object listener, Class<? extends Event> event) {
        toUnregister.add((Triple<IEventBus, Object, Class<? extends Event>>)Triple.of((Object)bus, (Object)listener, event));
    }

    private static void onLoadComplete(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            toUnregister.forEach(t -> {
                ((IEventBus)t.getLeft()).unregister(t.getMiddle());
                try {
                    MethodHandle mh = getBusId;
                    if (mh != null) {
                        EventListenerHelper.getListenerList((Class)((Class)t.getRight())).getListeners(mh.invokeExact((EventBus)t.getLeft()));
                    }
                }
                catch (Throwable ex) {
                    log.warn("Failed to clear listener list of one-time event receiver, so the receiver has leaked. This is not a big deal.", ex);
                }
            });
            toUnregister.clear();
        });
    }

    public OneTimeEventReceiver(IEventBus bus, Consumer<? super T> listener) {
        this.bus = bus;
        this.listener = listener;
    }

    static {
        MethodHandle ret;
        log = LogManager.getLogger(OneTimeEventReceiver.class);
        try {
            ret = MethodHandles.lookup().unreflectGetter(ObfuscationReflectionHelper.findField(EventBus.class, (String)"busID"));
        }
        catch (IllegalAccessException e) {
            log.warn("Failed to set up EventBus reflection to release one-time event listeners, leaks will occur. This is not a big deal.");
            ret = null;
        }
        getBusId = ret;
        OneTimeEventReceiver.addModListener(FMLLoadCompleteEvent.class, OneTimeEventReceiver::onLoadComplete);
        toUnregister = new ArrayList<Triple<IEventBus, Object, Class<? extends Event>>>();
    }
}

