/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.player_mobs.sound;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.common.data.SoundDefinition;
import net.minecraftforge.registries.ForgeRegistries;
import se.gory_moon.player_mobs.repack.registrate.AbstractRegistrate;
import se.gory_moon.player_mobs.repack.registrate.builders.AbstractBuilder;
import se.gory_moon.player_mobs.repack.registrate.builders.BuilderCallback;
import se.gory_moon.player_mobs.repack.registrate.providers.DataGenContext;
import se.gory_moon.player_mobs.repack.registrate.util.nullness.NonNullBiFunction;
import se.gory_moon.player_mobs.repack.registrate.util.nullness.NonNullFunction;
import se.gory_moon.player_mobs.repack.registrate.util.nullness.NonnullType;
import se.gory_moon.player_mobs.sound.SoundProvider;
import se.gory_moon.player_mobs.utils.CustomRegistrate;

public class SoundBuilder<P>
extends AbstractBuilder<SoundEvent, SoundEvent, P, SoundBuilder<P>> {
    private final NonNullFunction<ResourceLocation, SoundEvent> factory;
    private final String modId;

    public SoundBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, String modId) {
        super(owner, parent, name, callback, ForgeRegistries.Keys.SOUND_EVENTS);
        this.modId = modId;
        this.factory = SoundEvent::new;
    }

    @Override
    @NonnullType
    protected SoundEvent createEntry() {
        return this.factory.apply(new ResourceLocation(this.modId, this.getName()));
    }

    public SoundBuilder<P> sound(NonNullBiFunction<SoundDefinition, SoundProvider, SoundDefinition> definitionProvider) {
        return this.baseSound((provider, ctx) -> (SoundDefinition)definitionProvider.apply(provider.noSubtitle(), (SoundProvider)provider));
    }

    public SoundBuilder<P> blockSound(NonNullBiFunction<SoundDefinition, SoundProvider, SoundDefinition> definitionProvider, String subtitle) {
        return (SoundBuilder)this.baseSound((provider, ctx) -> (SoundDefinition)definitionProvider.apply(provider.subtitle(this.blockSubtitle(ctx.getId())), (SoundProvider)provider)).lang(sound -> this.blockSubtitle(sound.m_11660_()), subtitle);
    }

    public SoundBuilder<P> entitySound(NonNullBiFunction<SoundDefinition, SoundProvider, SoundDefinition> definitionProvider, String subtitle) {
        return (SoundBuilder)this.baseSound((provider, ctx) -> (SoundDefinition)definitionProvider.apply(provider.subtitle(this.entitySubtitle(ctx.getId())), (SoundProvider)provider)).lang(sound -> this.entitySubtitle(sound.m_11660_()), subtitle);
    }

    private SoundBuilder<P> baseSound(NonNullBiFunction<SoundProvider, DataGenContext<SoundEvent, SoundEvent>, SoundDefinition> soundDefinitionProvider) {
        return (SoundBuilder)this.setData(CustomRegistrate.SOUND, (ctx, prov) -> prov.add(this.getName(), (SoundDefinition)soundDefinitionProvider.apply((SoundProvider)prov, (DataGenContext<SoundEvent, SoundEvent>)ctx)));
    }

    private String entitySubtitle(ResourceLocation location) {
        return location.m_135827_() + ".subtitles.entity." + this.getName();
    }

    private String blockSubtitle(ResourceLocation location) {
        return location.m_135827_() + ".subtitles.block." + this.getName();
    }
}

