/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.player_mobs.utils;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.gory_moon.player_mobs.Configs;
import se.gory_moon.player_mobs.utils.PlayerName;
import se.gory_moon.player_mobs.utils.ThreadUtils;

public class NameManager {
    public static final NameManager INSTANCE = new NameManager();
    private static final Logger LOGGER = LogManager.getLogger();
    private final Set<PlayerName> allNames = ConcurrentHashMap.newKeySet();
    private final Set<PlayerName> remoteNames = ConcurrentHashMap.newKeySet();
    private final Set<PlayerName> usedNames = ConcurrentHashMap.newKeySet();
    private final Queue<PlayerName> namePool = new ConcurrentLinkedQueue<PlayerName>();
    private boolean firstSync = true;
    private int tickTime = 0;
    private int syncTime = 0;
    @Nullable
    private CompletableFuture<Integer> syncFuture = null;
    private boolean setup = false;

    private NameManager() {
    }

    public void init() {
        if (!this.setup) {
            MinecraftForge.EVENT_BUS.addListener(this::serverTick);
            this.setup = true;
            this.updateNameList();
        }
    }

    public PlayerName getRandomName() {
        PlayerName name = this.namePool.poll();
        if (name == null) {
            name = new PlayerName("Gory_Moon");
        }
        this.useName(name);
        return name;
    }

    public void useName(PlayerName name) {
        this.namePool.remove(name);
        this.usedNames.add(name);
        if (this.namePool.isEmpty()) {
            this.updateNameList();
        }
    }

    public Optional<PlayerName> findName(String name) {
        for (PlayerName playerName : this.allNames) {
            if (!playerName.getDisplayName().equalsIgnoreCase(name)) continue;
            return Optional.of(playerName);
        }
        return Optional.empty();
    }

    private void updateNameList() {
        ObjectOpenHashSet allNames = new ObjectOpenHashSet();
        for (String[] name : (List)Configs.COMMON.mobNames.get()) {
            allNames.add(new PlayerName((String)name));
        }
        allNames.addAll(this.remoteNames);
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (this.setup && ((Boolean)Configs.COMMON.useWhitelist.get()).booleanValue() && server != null) {
            for (String name : server.m_6846_().m_11306_()) {
                allNames.add(new PlayerName(name));
            }
        }
        allNames.removeIf(PlayerName::isInvalid);
        this.allNames.clear();
        this.allNames.addAll((Collection<PlayerName>)allNames);
        if (this.namePool.size() > 0) {
            allNames.removeAll(this.usedNames);
            allNames.removeAll(this.namePool);
        } else {
            this.usedNames.clear();
        }
        ObjectArrayList names = new ObjectArrayList((Collection)allNames);
        Collections.shuffle(names);
        this.namePool.addAll((Collection<PlayerName>)names);
    }

    private void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++this.syncTime;
            if (this.tickTime > 0 && this.syncTime >= this.tickTime || this.firstSync) {
                this.syncTime = 0;
                this.firstSync = false;
                this.reloadRemoteLinks();
            }
        }
    }

    public void configLoad() {
        this.tickTime = (Integer)Configs.COMMON.nameLinksSyncTime.get() * 1200;
        this.updateNameList();
    }

    public CompletableFuture<Integer> reloadRemoteLinks() {
        if (this.syncFuture != null && !this.syncFuture.isDone()) {
            return CompletableFuture.completedFuture(0);
        }
        this.syncFuture = CompletableFuture.supplyAsync(() -> {
            ObjectOpenHashSet nameList = new ObjectOpenHashSet();
            for (String link : (List)Configs.COMMON.nameLinks.get()) {
                try {
                    URL url = new URL(link);
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            nameList.add(new PlayerName(line));
                        }
                    }
                }
                catch (IOException e) {
                    LOGGER.error(String.format("Error fetching names from %s", link), (Throwable)e);
                }
            }
            int diff = nameList.size();
            ThreadUtils.tryRunOnMain(() -> this.lambda$reloadRemoteLinks$0((Set)nameList));
            return diff;
        }, Util.m_183991_());
        return this.syncFuture;
    }

    private /* synthetic */ void lambda$reloadRemoteLinks$0(Set nameList) {
        this.remoteNames.clear();
        this.remoteNames.addAll(nameList);
        this.updateNameList();
    }
}

