/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.player_mobs.world;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.MobSpawnSettingsBuilder;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import se.gory_moon.player_mobs.world.BiomeModifierRegistry;

public record AddSpawnsToSameAsEntityBiomeModifier(EntityType<?> entityType, List<MobSpawnSettings.SpawnerData> spawners) implements BiomeModifier
{
    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD) {
            MobSpawnSettingsBuilder spawnBuilder = builder.getMobSpawnSettings();
            boolean foundEntity = false;
            for (MobCategory category : MobCategory.values()) {
                if (!spawnBuilder.getSpawner(category).stream().anyMatch(spawnerData -> spawnerData.f_48404_.equals(this.entityType))) continue;
                foundEntity = true;
                break;
            }
            if (!foundEntity) {
                return;
            }
            for (MobSpawnSettings.SpawnerData spawner : this.spawners) {
                spawnBuilder.m_48376_(spawner.f_48404_.m_20674_(), spawner);
            }
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)BiomeModifierRegistry.ADD_SPAWN_AS_ENTITY_CODEC.get();
    }
}

