/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.entityscreen.instance;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.onewhohears.dscombat.util.UtilRender;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class EntityScreenInstance
implements AutoCloseable {
    @Nullable
    private final RenderType baseRenderType;

    public EntityScreenInstance(int id, @Nullable ResourceLocation baseTexture) {
        this.baseRenderType = baseTexture != null ? RenderType.m_110497_((ResourceLocation)baseTexture) : null;
    }

    public void draw(Entity entity, PoseStack poseStack, MultiBufferSource buffer, float partialTicks, int packedLight, float worldWidth, float worldHeight) {
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        this.draw(entity, matrix4f, buffer, partialTicks, packedLight, worldWidth, worldHeight);
    }

    public void draw(Entity entity, Matrix4f matrix4f, MultiBufferSource buffer, float partialTicks, int packedLight, float worldWidth, float worldHeight) {
        if (this.baseRenderType != null) {
            UtilRender.drawTextureCentered(this.baseRenderType, matrix4f, buffer, packedLight, 0.0f);
        }
    }

    @Override
    public void close() {
    }
}

