/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.event.forgebus;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.onewhohears.dscombat.client.input.DSCClientInputs;
import com.onewhohears.dscombat.client.model.obj.ObjWeaponRackModel;
import com.onewhohears.dscombat.client.renderer.EntityScreenRenderer;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dscombat", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientRenderEvents {
    private static Matrix4f viewMat = new Matrix4f();
    private static Matrix4f projMat = new Matrix4f();

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void playerRenderPre(RenderPlayerEvent.Pre event) {
        Player player = event.getEntity();
        if (!player.m_20159_()) {
            return;
        }
        Entity entity = player.m_20201_();
        if (!(entity instanceof EntityVehicle)) {
            return;
        }
        EntityVehicle plane = (EntityVehicle)entity;
        Quaternion q = UtilAngles.lerpQ((float)event.getPartialTick(), (Quaternion)plane.getPrevQ(), (Quaternion)plane.getClientQ());
        Vec3 eye = new Vec3(0.0, (double)player.m_20192_(), 0.0);
        Vec3 t = eye.m_82546_(UtilAngles.rotateVector((Vec3)eye, (Quaternion)q));
        event.getPoseStack().m_85837_(t.f_82479_, t.f_82480_, t.f_82481_);
        event.getPoseStack().m_85845_(q);
        float[] relangles = UtilAngles.globalToRelativeDegrees((float)player.m_146909_(), (float)player.m_146908_(), (Quaternion)q);
        player.m_5616_(relangles[1]);
        player.f_20886_ = relangles[1];
        player.m_5618_(relangles[1]);
        player.f_20884_ = relangles[1];
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void playerRenderPost(RenderPlayerEvent.Post event) {
        Player player = event.getEntity();
        if (!player.m_20159_()) {
            return;
        }
        Entity entity = player.m_20201_();
        if (!(entity instanceof EntityVehicle)) {
            return;
        }
        EntityVehicle plane = (EntityVehicle)entity;
        player.m_5616_(player.m_146908_());
        player.f_20886_ = player.m_146908_();
        player.m_5618_(player.m_146908_());
        player.f_20884_ = player.m_146908_();
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void getViewMatrices(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS) {
            return;
        }
        Minecraft m = Minecraft.m_91087_();
        Vec3 view = m.f_91063_.m_109153_().m_90583_();
        PoseStack poseStack = event.getPoseStack();
        poseStack.m_85836_();
        poseStack.m_85837_(-view.f_82479_, -view.f_82480_, -view.f_82481_);
        viewMat = poseStack.m_85850_().m_85861_();
        projMat = event.getProjectionMatrix();
        poseStack.m_85849_();
        ObjWeaponRackModel.renderedRackWeaponNum = 0;
    }

    @SubscribeEvent
    public static void onRenderGui(RenderGuiOverlayEvent.Pre event) {
        Entity entity = Minecraft.m_91087_().f_91074_.m_20201_();
        if (!(entity instanceof EntityVehicle)) {
            return;
        }
        EntityVehicle vehicle = (EntityVehicle)entity;
        if (DSCClientInputs.isCameraFree()) {
            return;
        }
        if (Objects.equals(event.getOverlay().id(), VanillaGuiOverlay.HOTBAR.id())) {
            event.setCanceled(true);
        }
        if (Objects.equals(event.getOverlay().id(), VanillaGuiOverlay.CROSSHAIR.id())) {
            event.setCanceled(true);
        }
        if (Objects.equals(event.getOverlay().id(), VanillaGuiOverlay.PLAYER_HEALTH.id())) {
            event.setCanceled(true);
        }
        if (Objects.equals(event.getOverlay().id(), VanillaGuiOverlay.ARMOR_LEVEL.id())) {
            event.setCanceled(true);
        }
        if (Objects.equals(event.getOverlay().id(), VanillaGuiOverlay.FOOD_LEVEL.id())) {
            event.setCanceled(true);
        }
        if (Objects.equals(event.getOverlay().id(), VanillaGuiOverlay.EXPERIENCE_BAR.id())) {
            event.setCanceled(true);
        }
        if (Objects.equals(event.getOverlay().id(), VanillaGuiOverlay.ITEM_NAME.id())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderHand(RenderHandEvent event) {
        Entity entity = Minecraft.m_91087_().f_91074_.m_20201_();
        if (!(entity instanceof EntityVehicle)) {
            return;
        }
        EntityVehicle vehicle = (EntityVehicle)entity;
        if (DSCClientInputs.isCameraLockedForward() || DSCClientInputs.isGimbalMode()) {
            event.setCanceled(true);
        }
    }

    public static Matrix4f getViewMatrix() {
        return viewMat;
    }

    public static Matrix4f getProjMatrix() {
        return projMat;
    }

    @SubscribeEvent
    public static void clientLogout(ClientPlayerNetworkEvent.LoggingOut event) {
        EntityScreenRenderer.clearCache();
    }
}

