/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.input;

import com.onewhohears.dscombat.data.radar.RadarStats;
import net.minecraft.client.Minecraft;

public class DSCClientInputs {
    public static boolean disable3rdPersonVehicle = false;
    public static boolean planeArcadePhysicsMode = false;
    private static double mouseCenterX = 0.0;
    private static double mouseCenterY = 0.0;
    private static int hoverIndex = -1;
    private static double radarDisplayRange = 10000.0;
    public static final long MOUNT_SHOOT_COOLDOWN = 500L;
    private static long mountTime;
    private static double LEAN_AMOUNT;
    private static MouseMode CURRENT_MOUSE_MODE;
    private static RadarStats.RadarMode PREFERRED_RADAR_MODE;
    private static TargetMode TARGET_MODE;
    private static boolean GIMBAL_MODE;
    private static boolean AFTERBURNER;
    private static boolean TURN_ASSIST;
    private static boolean CAMERA_TRACK_TARGET;
    public static float xRotPreTrack;
    public static float yRotPreTrack;

    public static boolean isCameraTrackTarget() {
        return CAMERA_TRACK_TARGET;
    }

    public static boolean toggleCameraTrackTarget() {
        CAMERA_TRACK_TARGET = !CAMERA_TRACK_TARGET;
        return CAMERA_TRACK_TARGET;
    }

    public static RadarStats.RadarMode getPreferredRadarMode() {
        return PREFERRED_RADAR_MODE;
    }

    public static RadarStats.RadarMode cyclePreferredRadarMode() {
        PREFERRED_RADAR_MODE = PREFERRED_RADAR_MODE.cycle();
        return PREFERRED_RADAR_MODE;
    }

    public static void setPreferredRadarMode(RadarStats.RadarMode mode) {
        PREFERRED_RADAR_MODE = mode;
    }

    public static boolean isGimbalMode() {
        return GIMBAL_MODE;
    }

    public static void toggleGimbalMode() {
        GIMBAL_MODE = !GIMBAL_MODE;
    }

    public static void setGimbalMode(boolean mode) {
        GIMBAL_MODE = mode;
    }

    public static void centerMousePos() {
        Minecraft m = Minecraft.m_91087_();
        mouseCenterX = m.f_91067_.m_91589_();
        mouseCenterY = m.f_91067_.m_91594_();
    }

    public static double getMouseCenterX() {
        return mouseCenterX;
    }

    public static double getMouseCenterY() {
        return mouseCenterY;
    }

    public static void setMouseCenterX(double x) {
        mouseCenterX = x;
    }

    public static void setMouseCenterY(double y) {
        mouseCenterY = y;
    }

    public static int getRadarHoverIndex() {
        return hoverIndex;
    }

    public static void setRadarHoverIndex(int index) {
        hoverIndex = index;
    }

    public static void resetRadarHoverIndex() {
        hoverIndex = -1;
    }

    public static boolean isRadarHovering() {
        return hoverIndex != -1;
    }

    public static double getRadarDisplayRange() {
        return radarDisplayRange;
    }

    public static void setRadarDisplayRange(double range) {
        if (range < 10.0) {
            range = 10.0;
        }
        radarDisplayRange = range;
    }

    public static void cycleRadarDisplayRange() {
        double range = DSCClientInputs.getRadarDisplayRange();
        range = range <= 250.0 ? 1000.0 : (range <= 1000.0 ? 2000.0 : (range <= 2000.0 ? 5000.0 : (range <= 5000.0 ? 10000.0 : (range <= 10000.0 ? 20000.0 : (range <= 20000.0 ? 50000.0 : (range <= 50000.0 ? 250.0 : 250.0))))));
        DSCClientInputs.setRadarDisplayRange(range);
    }

    public static long getClientMountTime() {
        return mountTime;
    }

    public static void setClientMountTime(long time) {
        mountTime = time;
    }

    public static MouseMode getMouseMode() {
        return CURRENT_MOUSE_MODE;
    }

    public static MouseMode cycleMouseMode() {
        CURRENT_MOUSE_MODE = CURRENT_MOUSE_MODE.cycle();
        return CURRENT_MOUSE_MODE;
    }

    public static boolean isCameraLockedForward() {
        return CURRENT_MOUSE_MODE.isLockedForward();
    }

    public static boolean isCameraFree() {
        return CURRENT_MOUSE_MODE.isFree();
    }

    public static boolean isCameraFreeRelative() {
        return CURRENT_MOUSE_MODE.isFreeRelative();
    }

    public static boolean isCameraFreeGlobal() {
        return CURRENT_MOUSE_MODE.isFreeGlobal();
    }

    public static boolean isTurnAssist() {
        return TURN_ASSIST;
    }

    public static void toggleTurnAssist() {
        TURN_ASSIST = !TURN_ASSIST;
    }

    public static TargetMode getTargetMode() {
        return TARGET_MODE;
    }

    public static void setTargetMode(TargetMode targetMode) {
        TARGET_MODE = targetMode;
    }

    public static void setLeanAmount(double leanAmount) {
        LEAN_AMOUNT = leanAmount;
    }

    public static double getLeanAmount() {
        return LEAN_AMOUNT;
    }

    public static void leanLeft() {
        if (DSCClientInputs.getLeanAmount() < 0.0) {
            DSCClientInputs.leanNot();
        } else {
            DSCClientInputs.setLeanAmount(-0.6);
        }
    }

    public static void leanRight() {
        if (DSCClientInputs.getLeanAmount() > 0.0) {
            DSCClientInputs.leanNot();
        } else {
            DSCClientInputs.setLeanAmount(0.6);
        }
    }

    public static void leanNot() {
        DSCClientInputs.setLeanAmount(0.0);
    }

    public static boolean isAfterBurner() {
        return AFTERBURNER;
    }

    public static void toggleAfterBurner() {
        AFTERBURNER = !AFTERBURNER;
    }

    static {
        LEAN_AMOUNT = 0.0;
        CURRENT_MOUSE_MODE = MouseMode.FREE_RELATIVE;
        PREFERRED_RADAR_MODE = RadarStats.RadarMode.ALL;
        TARGET_MODE = TargetMode.LOOK;
        GIMBAL_MODE = false;
        AFTERBURNER = false;
        TURN_ASSIST = true;
        CAMERA_TRACK_TARGET = false;
    }

    public static enum MouseMode {
        FREE_RELATIVE,
        FREE_GLOBAL,
        LOCKED_FORWARD;


        public MouseMode cycle() {
            int index = this.ordinal();
            if (index == MouseMode.values().length - 1) {
                return MouseMode.values()[0];
            }
            return MouseMode.values()[++index];
        }

        public boolean isLockedForward() {
            return this == LOCKED_FORWARD;
        }

        public boolean isFree() {
            return this == FREE_RELATIVE || this == FREE_GLOBAL;
        }

        public boolean isFreeRelative() {
            return this == FREE_RELATIVE;
        }

        public boolean isFreeGlobal() {
            return this == FREE_GLOBAL;
        }
    }

    public static enum TargetMode {
        LOOK,
        COORDS,
        INDICATOR;


        public String getTranslatable() {
            return "targetmode.dscombat." + this.name().toLowerCase();
        }
    }
}

