/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.model.obj;

import com.google.gson.JsonArray;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.onewhohears.dscombat.client.renderer.RendererEntityVehicle;
import com.onewhohears.dscombat.data.vehicle.client.VehicleClientStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.client.model.obj.customanims.keyframe.KeyframeAnimsEntityModel;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.client.model.renderable.ITextureRenderTypeLookup;

public class ObjVehicleModel<T extends EntityVehicle>
extends KeyframeAnimsEntityModel<T> {
    public ObjVehicleModel(String modelId) {
        this(modelId, new JsonArray());
    }

    public ObjVehicleModel(String modelId, JsonArray anims) {
        super(modelId, anims, new String[0]);
    }

    public ObjVehicleModel(String modelId, JsonArray anims, String ... animDataIds) {
        super(modelId, anims, animDataIds);
    }

    public ObjVehicleModel(String modelId, String[] animDataIds) {
        this(modelId, new JsonArray(), animDataIds);
    }

    protected ITextureRenderTypeLookup getTextureRenderTypeLookup(T entity) {
        return texture -> {
            String path = texture.m_135815_();
            ResourceLocation loc = texture;
            if (path.contains("base")) {
                loc = entity.textureManager.getDynamicTexture();
            } else if (path.contains("extra_")) {
                int index = path.indexOf("extra_");
                String[] extras = path.substring(index).split("_");
                String newLoc = path.substring(0, index) + extras[0] + "_" + extras[1] + "_" + entity.textureManager.getBaseTextureIndex() + ".png";
                loc = new ResourceLocation(texture.m_135827_(), newLoc);
            }
            if (((VehicleClientStats)entity.getAssets()).isDontCull()) {
                return RendererEntityVehicle.getBaseRenderType(loc);
            }
            return RendererEntityVehicle.getCullBaseRenderType(loc);
        };
    }

    public void render(T entity, PoseStack poseStack, MultiBufferSource bufferSource, int lightmap, float partialTicks) {
        this.handleGlobalOverrides((Entity)entity, partialTicks, poseStack);
        this.rotate(entity, partialTicks, poseStack);
        this.getModel().render(poseStack, bufferSource, this.getTextureRenderTypeLookup(entity), this.getLight(entity, lightmap), this.getOverlay((Entity)entity), partialTicks, this.getComponentTransforms((Entity)entity, partialTicks));
    }

    protected void rotate(T entity, float partialTicks, PoseStack poseStack) {
        Quaternion q = UtilAngles.lerpQ((float)partialTicks, (Quaternion)((EntityVehicle)entity).getPrevQ(), (Quaternion)((EntityVehicle)entity).getClientQ());
        Vector3f pivot = this.getGlobalPivot();
        if (!UtilGeometry.isZero((Vector3f)pivot)) {
            poseStack.m_166854_(UtilAngles.pivotInvRot((Vector3f)pivot, (Quaternion)q));
        } else {
            poseStack.m_85845_(q);
        }
    }

    protected int getLight(T entity, int lightmap) {
        if (!((EntityVehicle)entity).isOperational()) {
            return 1;
        }
        return lightmap;
    }
}

