/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.model.obj;

import com.mojang.blaze3d.vertex.PoseStack;
import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.model.obj.ObjPartModel;
import com.onewhohears.dscombat.entity.parts.EntityWeaponRack;
import com.onewhohears.onewholibs.client.model.obj.ObjEntityModels;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.renderable.CompositeRenderable;

public class ObjWeaponRackModel<T extends EntityWeaponRack>
extends ObjPartModel<T> {
    public static final int maxRenderedRackWeaponNum = 30;
    public static int renderedRackWeaponNum = 0;
    protected final int maxAmmoNum;
    protected final Vec3[] weapon_pos;
    private String prevWeaponModelId = "";
    private CompositeRenderable prevModel;
    private ObjEntityModels.ModelOverrides prevMO;

    public ObjWeaponRackModel(String modelId, int maxAmmoNum, Vec3[] weapon_pos) {
        super(modelId);
        this.maxAmmoNum = maxAmmoNum;
        this.weapon_pos = weapon_pos;
    }

    @Override
    public void render(T entity, PoseStack poseStack, MultiBufferSource bufferSource, int lightmap, float partialTicks) {
        ObjEntityModels.ModelOverrides mo;
        CompositeRenderable model;
        super.render(entity, poseStack, bufferSource, lightmap, partialTicks);
        if (renderedRackWeaponNum > (Integer)Config.CLIENT.maxRenderRackMissileNum.get()) {
            return;
        }
        String weaponModelId = ((EntityWeaponRack)((Object)entity)).getWeaponModelId();
        if (weaponModelId == null || weaponModelId.isEmpty()) {
            return;
        }
        if (weaponModelId.equals(this.prevWeaponModelId)) {
            model = this.prevModel;
            mo = this.prevMO;
        } else {
            model = this.getWeaponModel(weaponModelId);
            mo = this.getWeaponModelOverride(weaponModelId);
        }
        int ammo = ((EntityWeaponRack)((Object)entity)).getAmmoNum();
        for (int i = 0; i < ammo && i < this.maxAmmoNum; ++i) {
            Vec3 v = this.weapon_pos[i];
            this.renderWeapon(entity, poseStack, bufferSource, lightmap, partialTicks, model, mo, v.f_82479_, v.f_82480_, v.f_82481_);
        }
        this.prevWeaponModelId = weaponModelId;
        this.prevModel = model;
        this.prevMO = mo;
    }

    protected void renderWeapon(T entity, PoseStack poseStack, MultiBufferSource bufferSource, int lightmap, float partialTicks, CompositeRenderable model, ObjEntityModels.ModelOverrides mo, double x, double y, double z) {
        poseStack.m_85836_();
        poseStack.m_85837_(x, y, z);
        mo.apply(poseStack);
        model.render(poseStack, bufferSource, RenderType::m_110446_, lightmap, OverlayTexture.f_118083_, partialTicks, CompositeRenderable.Transforms.EMPTY);
        poseStack.m_85849_();
        ++renderedRackWeaponNum;
    }

    protected CompositeRenderable getWeaponModel(String modelId) {
        return ObjEntityModels.get().getBakedModel(modelId);
    }

    protected ObjEntityModels.ModelOverrides getWeaponModelOverride(String modelId) {
        return ObjEntityModels.get().getModelOverride(modelId);
    }
}

