/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.model.obj.custom;

import com.google.common.collect.ImmutableMap;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.onewhohears.dscombat.client.model.obj.ObjVehicleModel;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import net.minecraftforge.client.model.renderable.CompositeRenderable;

public class BroncoPlaneModel
extends ObjVehicleModel<EntityVehicle> {
    private static final Vector3f PIVOT = new Vector3f(0.0f, -2.0f, 2.0f);

    public BroncoPlaneModel() {
        super("bronco-plane");
    }

    protected CompositeRenderable.Transforms getComponentTransforms(EntityVehicle entity, float partialTicks) {
        Matrix4f right_flap;
        Matrix4f left_flap;
        Matrix4f lg0_mat;
        Matrix4f lg1_mat;
        Matrix4f lg2_mat;
        float bladerot = entity.getMotorRotation(partialTicks, 30.0f);
        float gearpos = entity.getLandingGearPos(partialTicks);
        Matrix4f blade0rot_mat = UtilAngles.pivotPixelsRotZ((float)44.8001f, (float)32.256f, (float)11.0114f, (float)bladerot);
        Matrix4f blade1rot_mat = UtilAngles.pivotPixelsRotZ((float)-44.8001f, (float)32.256f, (float)11.0114f, (float)bladerot);
        if (gearpos >= 1.0f) {
            lg1_mat = lg2_mat = INVISIBLE;
            lg0_mat = lg2_mat;
        } else {
            float degrees = gearpos * 90.0f;
            lg0_mat = UtilAngles.pivotPixelsRotX((float)-0.5f, (float)18.0f, (float)50.5f, (float)degrees);
            lg1_mat = UtilAngles.pivotPixelsRotX((float)41.5f, (float)24.0f, (float)-24.5f, (float)degrees);
            lg2_mat = UtilAngles.pivotPixelsRotX((float)-42.5f, (float)24.0f, (float)-24.5f, (float)degrees);
        }
        Quaternion rudderRot = Vector3f.f_122225_.m_122240_(entity.inputs.yaw * 15.0f);
        rudderRot.m_80148_(Vector3f.f_122227_.m_122240_(entity.inputs.yaw * -10.0f));
        Matrix4f left_rudder = UtilAngles.pivotPixelsRot((float)44.7787f, (float)52.3335f, (float)-127.6889f, (Quaternion)rudderRot);
        Matrix4f right_rudder = UtilAngles.pivotPixelsRot((float)-44.7787f, (float)52.3335f, (float)-127.6889f, (Quaternion)rudderRot);
        Matrix4f elevator = UtilAngles.pivotPixelsRotX((float)0.0f, (float)73.6614f, (float)-140.7049f, (float)(entity.inputs.pitch * 22.0f));
        if (entity.isFlapsDown()) {
            left_flap = UtilAngles.pivotPixelsRotX((float)98.9282f, (float)43.4165f, (float)-34.7215f, (float)-22.0f);
            right_flap = UtilAngles.pivotPixelsRotX((float)-98.9282f, (float)43.4165f, (float)-34.7215f, (float)-22.0f);
        } else {
            left_flap = UtilAngles.pivotPixelsRotX((float)98.9282f, (float)43.4165f, (float)-34.7215f, (float)(entity.inputs.roll * -22.0f));
            right_flap = UtilAngles.pivotPixelsRotX((float)-98.9282f, (float)43.4165f, (float)-34.7215f, (float)(entity.inputs.roll * 22.0f));
        }
        Quaternion stickRot = Vector3f.f_122223_.m_122240_(entity.inputs.pitch * -25.0f);
        stickRot.m_80148_(Vector3f.f_122227_.m_122240_(entity.inputs.roll * 25.0f));
        Matrix4f stick = UtilAngles.pivotPixelsRot((float)0.0f, (float)26.1123f, (float)47.0f, (Quaternion)stickRot);
        Matrix4f left_pedal = Matrix4f.m_27653_((float)0.0f, (float)0.0f, (float)(entity.inputs.yaw * -0.0625f));
        Matrix4f right_pedal = Matrix4f.m_27653_((float)0.0f, (float)0.0f, (float)(entity.inputs.yaw * 0.0625f));
        Matrix4f throttle = Matrix4f.m_27653_((float)0.0f, (float)0.0f, (float)(entity.getCurrentThrottle() * 0.125f));
        ImmutableMap transforms = ImmutableMap.builder().put((Object)"blade0", (Object)blade0rot_mat).put((Object)"blade1", (Object)blade1rot_mat).put((Object)"lg0", (Object)lg0_mat).put((Object)"lg1", (Object)lg1_mat).put((Object)"lg2", (Object)lg2_mat).put((Object)"surface0", (Object)left_flap).put((Object)"surface1", (Object)right_flap).put((Object)"surface2", (Object)left_rudder).put((Object)"surface3", (Object)right_rudder).put((Object)"surface4", (Object)elevator).put((Object)"stick", (Object)stick).put((Object)"pedal0", (Object)left_pedal).put((Object)"pedal1", (Object)right_pedal).put((Object)"throttle", (Object)throttle).build();
        return CompositeRenderable.Transforms.of((ImmutableMap)transforms);
    }

    public Vector3f getGlobalPivot() {
        return PIVOT;
    }
}

