/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.loading.FMLPaths;

public final class HudLayoutManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path FILE = FMLPaths.CONFIGDIR.get().resolve("dscombat_hud_layout.json");
    private static Map<String, Map<String, Rect>> layouts = new HashMap<String, Map<String, Rect>>();
    private static boolean loaded = false;

    private HudLayoutManager() {
    }

    public static void load() {
        if (loaded) {
            return;
        }
        loaded = true;
        if (!Files.exists(FILE, new LinkOption[0])) {
            return;
        }
        try (BufferedReader r = Files.newBufferedReader(FILE, StandardCharsets.UTF_8);){
            Type t = new TypeToken<Map<String, Map<String, Rect>>>(){}.getType();
            Map data = (Map)GSON.fromJson((Reader)r, t);
            if (data != null) {
                layouts = data;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void save() {
        try (BufferedWriter w = Files.newBufferedWriter(FILE, StandardCharsets.UTF_8, new OpenOption[0]);){
            GSON.toJson(layouts, (Appendable)w);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Map<String, Rect> vehicleMap(String vt) {
        HudLayoutManager.load();
        return layouts.computeIfAbsent(vt, k -> new HashMap());
    }

    public static Rect get(String vt, String id, Rect fallback) {
        Map<String, Rect> m = HudLayoutManager.vehicleMap(vt);
        return m.getOrDefault(id, fallback);
    }

    public static void set(String vt, String id, Rect rect) {
        HudLayoutManager.vehicleMap(vt).put(id, rect);
    }

    public static class Rect {
        public double x;
        public double y;
        public double w;
        public double h;

        public Rect() {
        }

        public Rect(double x, double y, double w, double h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }
    }
}

