/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.overlay.components;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.client.overlay.VehicleOverlayComponent;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.UtilParse;
import net.minecraft.client.gui.Font;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import org.jetbrains.annotations.NotNull;

public class DebugOverlay
extends VehicleOverlayComponent {
    @Override
    protected boolean shouldRender(ForgeGui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        if (DebugOverlay.defaultRenderConditions()) {
            return false;
        }
        return DebugOverlay.getPlayerRootVehicle() instanceof EntityVehicle && (Boolean)Config.CLIENT.debugMode.get() != false;
    }

    @Override
    protected void render(ForgeGui gui, PoseStack stack, float partialTick, int screenWidth, int screenHeight) {
        EntityVehicle vehicle = (EntityVehicle)DebugOverlay.getPlayerRootVehicle();
        assert (vehicle != null);
        int color = 65280;
        int space = 120;
        DebugOverlay.m_93236_((PoseStack)stack, (Font)FONT, (String)("V" + UtilParse.prettyVec3((Vec3)vehicle.m_20184_(), (int)2)), (int)(screenWidth - space), (int)0, (int)color);
        DebugOverlay.m_93236_((PoseStack)stack, (Font)FONT, (String)("F" + UtilParse.prettyVec3((Vec3)vehicle.forces, (int)2)), (int)(screenWidth - space), (int)10, (int)color);
        DebugOverlay.m_93236_((PoseStack)stack, (Font)FONT, (String)("A" + UtilParse.prettyVec3((Vec3)vehicle.getAngularVel(), (int)2)), (int)(screenWidth - space), (int)20, (int)color);
        DebugOverlay.m_93236_((PoseStack)stack, (Font)FONT, (String)("M" + UtilParse.prettyVec3((Vec3)vehicle.getMoment(), (int)2)), (int)(screenWidth - space), (int)30, (int)color);
        DebugOverlay.m_93236_((PoseStack)stack, (Font)FONT, (String)("Q" + UtilParse.prettyQ((Quaternion)vehicle.getClientQ(), (int)2)), (int)(screenWidth - space), (int)40, (int)color);
        DebugOverlay.m_93236_((PoseStack)stack, (Font)FONT, (String)("YR: " + String.format("%3.2f", Float.valueOf(vehicle.getYawRate() * 20.0f)) + " TR: " + String.format("%3.2f", Float.valueOf(vehicle.getActualTurnRadius()))), (int)(screenWidth - space), (int)50, (int)color);
    }

    @Override
    @NotNull
    protected String componentId() {
        return "dscombat_debug";
    }
}

