/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.client.sounds;

import com.onewhohears.onewholibs.util.math.UtilGeometry;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class DopplerSoundInstance
extends AbstractTickableSoundInstance {
    protected static final float MIN_VOL = 0.001f;
    protected final LocalPlayer player;
    protected final Entity entity;
    protected final float velocitySound;
    protected final float volDecreaseRate;
    protected final float minDistSqr;
    protected float initVolume;
    protected float initPitch;

    public DopplerSoundInstance(SoundEvent sound, LocalPlayer player, Entity entity, float initVolume, float initPitch, float velSound) {
        this(sound, player, entity, SoundSource.PLAYERS, initVolume, initPitch, velSound, 160.0, 0.0f);
    }

    public DopplerSoundInstance(SoundEvent sound, LocalPlayer player, Entity entity, float initVolume, float initPitch, float velSound, double range) {
        this(sound, player, entity, SoundSource.PLAYERS, initVolume, initPitch, velSound, range, 0.0f);
    }

    public DopplerSoundInstance(SoundEvent sound, LocalPlayer player, Entity entity, float initVolume, float initPitch, float velSound, double range, float minDist) {
        this(sound, player, entity, SoundSource.PLAYERS, initVolume, initPitch, velSound, range, minDist);
    }

    public DopplerSoundInstance(SoundEvent sound, LocalPlayer player, Entity entity, SoundSource soundSource, float initVolume, float initPitch, float velSound, double range, float minDist) {
        super(sound, soundSource, SoundInstance.m_235150_());
        this.player = player;
        this.entity = entity;
        this.f_119578_ = true;
        this.f_119579_ = 0;
        this.f_119573_ = 0.001f;
        this.initVolume = initVolume;
        this.f_119574_ = initPitch;
        this.initPitch = initPitch;
        this.velocitySound = velSound;
        this.volDecreaseRate = (float)(1.0 / (range * range));
        this.minDistSqr = minDist * minDist;
    }

    public void m_7788_() {
        if (this.entity.m_213877_()) {
            this.m_119609_();
            return;
        }
        this.f_119575_ = this.entity.m_20185_();
        this.f_119576_ = this.entity.m_20186_();
        this.f_119577_ = this.entity.m_20189_();
        float minLess = this.minDistSqr - 400.0f;
        float d2 = (float)this.player.m_20280_(this.entity);
        this.f_119573_ = d2 <= minLess ? 0.001f : (d2 > minLess && d2 < this.minDistSqr ? Math.max(0.001f, this.initVolume * (d2 - minLess) * 0.01f) : Math.max(0.001f, this.initVolume - d2 * this.volDecreaseRate));
        Vec3 dPos = this.entity.m_20182_().m_82546_(this.player.m_20182_());
        float velPlayer = (float)UtilGeometry.vecCompMagDirByAxis((Vec3)this.player.m_20184_(), (Vec3)dPos);
        float velEntity = (float)UtilGeometry.vecCompMagDirByAxis((Vec3)this.entity.m_20184_(), (Vec3)dPos);
        this.f_119574_ = this.initPitch * ((this.velocitySound + velPlayer) / (this.velocitySound + velEntity));
        if (this.entity.m_20184_().m_82556_() > (double)(this.velocitySound * this.velocitySound) && velEntity <= 0.0f) {
            this.f_119573_ = 0.001f;
        }
    }
}

