/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.common.event;

import com.onewhohears.dscombat.command.DSCGameRules;
import com.onewhohears.dscombat.data.graph.StatGraphs;
import com.onewhohears.dscombat.data.parts.PartPresets;
import com.onewhohears.dscombat.data.radar.RadarPresets;
import com.onewhohears.dscombat.data.radar.TrackableEntitiesManager;
import com.onewhohears.dscombat.data.vehicle.VehiclePresets;
import com.onewhohears.dscombat.data.weapon.NonTickingMissileManager;
import com.onewhohears.dscombat.data.weapon.WeaponPresets;
import com.onewhohears.dscombat.entity.CustomExplosion;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.vehicle.hitbox.RotableHitboxes;
import com.onewhohears.onewholibs.common.event.GetJsonPresetListenersEvent;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetReloadListener;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dscombat", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class CommonForgeEvents {
    private static final Set<Integer> explodeRepeatCheck = new HashSet<Integer>();

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void livingHurtEvent(LivingHurtEvent event) {
        Entity entity;
        if (event.getSource().m_19387_()) {
            return;
        }
        if (!event.getEntity().m_20159_() || !((entity = event.getEntity().m_20201_()) instanceof EntityVehicle)) {
            return;
        }
        EntityVehicle plane = (EntityVehicle)entity;
        event.setAmount(plane.calcDamageToRider(event.getSource(), event.getAmount()));
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void explosionEvent(ExplosionEvent.Detonate event) {
        explodeRepeatCheck.clear();
        for (int i = 0; i < event.getAffectedEntities().size(); ++i) {
            Entity e = (Entity)event.getAffectedEntities().get(i);
            if (!e.m_6128_() || explodeRepeatCheck.contains(e.m_19879_()) || !(e instanceof CustomExplosion)) continue;
            CustomExplosion entity = (CustomExplosion)e;
            entity.customExplosionHandler(event.getExplosion());
            explodeRepeatCheck.add(e.m_19879_());
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.player.m_21255_() && event.player.f_19853_.m_46469_().m_46207_(DSCGameRules.DISABLE_ELYTRA_FLYING)) {
            event.player.m_36321_();
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void serverTickEvent(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        NonTickingMissileManager.serverTick(event.getServer());
        TrackableEntitiesManager.serverTick(event.getServer());
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void serverStoppingEvent(ServerStoppingEvent event) {
        VehiclePresets.close();
        WeaponPresets.close();
        RadarPresets.close();
        PartPresets.close();
        StatGraphs.close();
        RotableHitboxes.onServerStop();
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void addJsonPresetListener(GetJsonPresetListenersEvent event) {
        event.addListener((JsonPresetReloadListener)StatGraphs.get());
        event.addListener((JsonPresetReloadListener)VehiclePresets.get());
        event.addListener((JsonPresetReloadListener)WeaponPresets.get());
        event.addListener((JsonPresetReloadListener)RadarPresets.get());
        event.addListener((JsonPresetReloadListener)PartPresets.get());
    }
}

