/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.common.network.toclient;

import com.onewhohears.dscombat.common.network.IPacket;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.init.DataSerializers;
import com.onewhohears.dscombat.util.UtilClientPacket;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ToClientAddForceMoment
extends IPacket {
    public final int id;
    public final Vec3 force;
    public final Vec3 moment;

    public ToClientAddForceMoment(EntityVehicle craft, Vec3 force, Vec3 moment) {
        this.id = craft.m_19879_();
        this.force = force;
        this.moment = moment;
    }

    public ToClientAddForceMoment(FriendlyByteBuf buffer) {
        this.id = buffer.readInt();
        this.force = (Vec3)DataSerializers.VEC3.m_6709_(buffer);
        this.moment = (Vec3)DataSerializers.VEC3.m_6709_(buffer);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.id);
        DataSerializers.VEC3.m_6856_(buffer, (Object)this.force);
        DataSerializers.VEC3.m_6856_(buffer, (Object)this.moment);
    }

    @Override
    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            UtilClientPacket.addMomentPacket(this.id, this.force, this.moment);
            success.set(true);
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

