/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.common.network.toclient;

import com.onewhohears.dscombat.common.network.IPacket;
import com.onewhohears.dscombat.common.network.PacketHandler;
import com.onewhohears.dscombat.entity.parts.EntityTurret;
import com.onewhohears.dscombat.entity.parts.EntityWeaponRack;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.util.UtilClientPacket;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class ToClientOnShoot
extends IPacket {
    public final int vehicleId;
    public final int shooterId;
    public final UtilClientPacket.ShootType type;

    public static void onShootWeaponRack(EntityWeaponRack rack, Entity shooter) {
        if (rack.m_9236_().m_5776_()) {
            return;
        }
        PacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> rack), (Object)new ToClientOnShoot(rack.m_19879_(), shooter.m_19879_(), UtilClientPacket.ShootType.WEAPON_RACK));
    }

    public static void onShootTurret(EntityTurret turret, Entity shooter) {
        if (turret.m_9236_().m_5776_()) {
            return;
        }
        PacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> turret), (Object)new ToClientOnShoot(turret.m_19879_(), shooter.m_19879_(), UtilClientPacket.ShootType.TURRET));
    }

    public static void onShootFlareRack(EntityVehicle vehicle, Entity shooter) {
        if (vehicle.m_9236_().m_5776_()) {
            return;
        }
        PacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> vehicle), (Object)new ToClientOnShoot(vehicle.m_19879_(), shooter.m_19879_(), UtilClientPacket.ShootType.FLARE));
    }

    public static void onShootChaffRack(EntityVehicle vehicle, Entity shooter) {
        if (vehicle.m_9236_().m_5776_()) {
            return;
        }
        PacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> vehicle), (Object)new ToClientOnShoot(vehicle.m_19879_(), shooter.m_19879_(), UtilClientPacket.ShootType.CHAFF));
    }

    private ToClientOnShoot(int vehicleId, int shooterId, UtilClientPacket.ShootType type) {
        this.vehicleId = vehicleId;
        this.shooterId = shooterId;
        this.type = type;
    }

    public ToClientOnShoot(FriendlyByteBuf buffer) {
        this.vehicleId = buffer.readInt();
        this.shooterId = buffer.readInt();
        this.type = (UtilClientPacket.ShootType)buffer.m_130066_(UtilClientPacket.ShootType.class);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.vehicleId);
        buffer.writeInt(this.shooterId);
        buffer.m_130068_((Enum)this.type);
    }

    @Override
    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            UtilClientPacket.onShoot(this.vehicleId, this.shooterId, this.type);
            success.set(true);
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

