/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.common.network.toclient;

import com.onewhohears.dscombat.common.network.IPacket;
import com.onewhohears.dscombat.data.radar.RadarSystem;
import com.onewhohears.dscombat.util.UtilClientPacket;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ToClientRWRWarning
extends IPacket {
    public final int id;
    public final RadarSystem.RWRWarning warning;

    public ToClientRWRWarning(int id, RadarSystem.RWRWarning warning) {
        this.id = id;
        this.warning = warning;
    }

    public ToClientRWRWarning(FriendlyByteBuf buffer) {
        this.id = buffer.readInt();
        this.warning = new RadarSystem.RWRWarning(buffer);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.id);
        this.warning.write(buffer);
    }

    @Override
    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            UtilClientPacket.rwrPacket(this.id, this.warning);
            success.set(true);
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

