/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.common.network.toclient;

import com.onewhohears.dscombat.common.network.IPacket;
import com.onewhohears.dscombat.entity.parts.EntityChainHook;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.util.UtilClientPacket;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ToClientVehicleChainUpdate
extends IPacket {
    public final int vehicleId;
    public final int hookId;
    public final int playerId;
    public final EntityChainHook.ChainUpdateType type;

    public ToClientVehicleChainUpdate(@Nullable EntityVehicle vehicle, @Nullable EntityChainHook hook, @Nullable Player player, EntityChainHook.ChainUpdateType type) {
        this.vehicleId = vehicle != null ? vehicle.m_19879_() : -1;
        this.hookId = hook != null ? hook.m_19879_() : -1;
        this.playerId = player != null ? player.m_19879_() : -1;
        this.type = type;
    }

    public ToClientVehicleChainUpdate(FriendlyByteBuf buffer) {
        this.vehicleId = buffer.readInt();
        this.hookId = buffer.readInt();
        this.playerId = buffer.readInt();
        this.type = EntityChainHook.ChainUpdateType.values()[buffer.readInt()];
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.vehicleId);
        buffer.writeInt(this.hookId);
        buffer.writeInt(this.playerId);
        buffer.writeInt(this.type.ordinal());
    }

    @Override
    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> UtilClientPacket.updateVehicleChain(this.vehicleId, this.hookId, this.playerId, this.type)));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

