/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.common.network.toclient;

import com.onewhohears.dscombat.common.network.IPacket;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.util.UtilClientPacket;
import io.netty.buffer.ByteBuf;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ToClientVehicleTexture
extends IPacket {
    public final int ignore_player_id;
    public final int vehicle_id;
    private EntityVehicle vehicle;
    private ByteBuf buffer;

    public ToClientVehicleTexture(Player ignorePlayer, EntityVehicle vehicle) {
        this.ignore_player_id = ignorePlayer.m_19879_();
        this.vehicle_id = vehicle.m_19879_();
        this.vehicle = vehicle;
    }

    public ToClientVehicleTexture(FriendlyByteBuf buffer) {
        this.ignore_player_id = buffer.readInt();
        this.vehicle_id = buffer.readInt();
        this.buffer = buffer.copy().asReadOnly();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.ignore_player_id);
        buffer.writeInt(this.vehicle_id);
        this.vehicle.textureManager.write(buffer);
    }

    @Override
    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            UtilClientPacket.vehicleTexturePacket(this.ignore_player_id, this.vehicle_id, this.buffer);
            success.set(true);
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

