/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.common.network.toclient;

import com.onewhohears.dscombat.common.network.IPacket;
import com.onewhohears.dscombat.util.UtilClientPacket;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class ToClientWeaponAmmo
extends IPacket {
    public final int id;
    public final String weaponId;
    public final String slotId;
    public final int ammo;

    public ToClientWeaponAmmo(int id, String weaponId, String slotId, int ammo) {
        this.id = id;
        this.weaponId = weaponId;
        this.slotId = slotId;
        this.ammo = ammo;
    }

    public ToClientWeaponAmmo(FriendlyByteBuf buffer) {
        this.id = buffer.readInt();
        this.weaponId = buffer.m_130277_();
        this.slotId = buffer.m_130277_();
        this.ammo = buffer.readInt();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.id);
        buffer.m_130070_(this.weaponId);
        buffer.m_130070_(this.slotId);
        buffer.writeInt(this.ammo);
    }

    @Override
    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            UtilClientPacket.weaponAmmoPacket(this.id, this.weaponId, this.slotId, this.ammo);
            success.set(true);
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

