/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.common.network.toserver;

import com.mojang.datafixers.util.Pair;
import com.onewhohears.dscombat.common.network.IPacket;
import com.onewhohears.dscombat.crafting.VehicleRecipe;
import com.onewhohears.onewholibs.util.UtilItem;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.network.NetworkEvent;

public class ToServerCraftPlane
extends IPacket {
    public final String recipeId;
    public final BlockPos pos;

    public ToServerCraftPlane(ResourceLocation recipeId, BlockPos pos) {
        this.recipeId = recipeId.toString();
        this.pos = pos;
    }

    public ToServerCraftPlane(FriendlyByteBuf buffer) {
        this.recipeId = buffer.m_130277_();
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        this.pos = new BlockPos(x, y, z);
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.recipeId);
        buffer.writeDouble((double)this.pos.m_123341_());
        buffer.writeDouble((double)this.pos.m_123342_());
        buffer.writeDouble((double)this.pos.m_123343_());
    }

    @Override
    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> {
            success.set(true);
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            Optional option = player.f_19853_.m_7465_().m_220248_((RecipeType)VehicleRecipe.Type.INSTANCE, (Container)player.m_150109_(), player.f_19853_, new ResourceLocation(this.recipeId));
            if (option.isEmpty()) {
                return;
            }
            VehicleRecipe recipe = (VehicleRecipe)((Pair)option.get()).getSecond();
            UtilItem.handleInventoryRecipe((Player)player, (Recipe)recipe, (BlockPos)this.pos);
        });
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

