/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.common.network.toserver;

import com.onewhohears.dscombat.common.network.IPacket;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class ToServerVehicleCollide
extends IPacket {
    public final int id;
    public final float amount;
    public final boolean isFall;

    public ToServerVehicleCollide(int id, float amount, boolean isFall) {
        this.id = id;
        this.amount = amount;
        this.isFall = isFall;
    }

    public ToServerVehicleCollide(FriendlyByteBuf buffer) {
        this.id = buffer.readInt();
        this.amount = buffer.readFloat();
        this.isFall = buffer.readBoolean();
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.id);
        buffer.writeFloat(this.amount);
        buffer.writeBoolean(this.isFall);
    }

    @Override
    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> {
            Level level = ((NetworkEvent.Context)ctx.get()).getSender().f_19853_;
            Entity patt1193$temp = level.m_6815_(this.id);
            if (patt1193$temp instanceof EntityVehicle) {
                EntityVehicle plane = (EntityVehicle)patt1193$temp;
                plane.collideHurt(this.amount, this.isFall);
            }
            success.set(true);
        });
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

