/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.crafting;

import com.onewhohears.dscombat.crafting.PartItemUnloadRecipe;
import com.onewhohears.dscombat.data.parts.instance.WeaponPartInstance;
import com.onewhohears.dscombat.data.parts.stats.WeaponPartStats;
import com.onewhohears.dscombat.data.weapon.WeaponPresets;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.init.ModRecipes;
import com.onewhohears.dscombat.item.ItemAmmo;
import com.onewhohears.dscombat.item.ItemWeaponPart;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class WeaponPartUnloadRecipe
extends PartItemUnloadRecipe<WeaponPartInstance<?>> {
    public WeaponPartUnloadRecipe(ResourceLocation id) {
        super(id);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.WEAPON_PART_UNLOAD.get();
    }

    @Override
    @Nonnull
    public ItemStack getNewAmmoItem(String continuity) {
        WeaponStats wd = WeaponPresets.get().get(continuity);
        if (wd == null) {
            return ItemStack.f_41583_;
        }
        return wd.getNewItem();
    }

    @Override
    public boolean isLoadablePartItem(ItemStack stack) {
        return stack.m_41720_() instanceof ItemWeaponPart;
    }

    @Override
    public boolean isItemAmmo(ItemStack stack) {
        return stack.m_41720_() instanceof ItemAmmo;
    }

    @Override
    public boolean checkAmmoContinuity() {
        return true;
    }

    @Override
    public String getItemAmmoContinuity(ItemStack stack) {
        return ItemAmmo.getWeaponId(stack);
    }

    @Override
    public boolean isContinuityValid(String continuity) {
        return WeaponPresets.get().has(continuity);
    }

    @Override
    public int getContinuityMaxAmmo(WeaponPartInstance<?> lpd, String continuity) {
        if (!this.isContinuityValid(continuity)) {
            return 0;
        }
        return ((WeaponPartStats)lpd.getStats()).getMaxAmmo();
    }
}

