/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.parts;

import com.onewhohears.dscombat.common.network.PacketHandler;
import com.onewhohears.dscombat.common.network.toclient.ToClientAddPart;
import com.onewhohears.dscombat.common.network.toclient.ToClientRemovePart;
import com.onewhohears.dscombat.common.network.toclient.ToClientSyncPart;
import com.onewhohears.dscombat.data.parts.PartType;
import com.onewhohears.dscombat.data.parts.SlotType;
import com.onewhohears.dscombat.data.parts.instance.PartInstance;
import com.onewhohears.dscombat.data.parts.stats.PartStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.init.DataSerializers;
import com.onewhohears.dscombat.util.UtilPresetParse;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetType;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.UtilParse;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class PartSlot {
    public static final String PILOT_SLOT_NAME = "pilot_seat";
    public static final String COPILOT_SLOT_NAME = "copilot_seat";
    private final String slotId;
    private final SlotType type;
    private final Vec3 pos;
    private final float zRot;
    private final boolean locked;
    private final String onlyCompatPart;
    private final String linkedHitbox;
    private PartInstance<?> data;

    public PartSlot(CompoundTag entityNbt, @Nullable CompoundTag presetNbt) {
        this.slotId = entityNbt.m_128461_("name");
        this.locked = entityNbt.m_128471_("locked");
        if (entityNbt.m_128441_("data")) {
            this.data = UtilPresetParse.parsePartFromCompound(entityNbt.m_128469_("data"));
        }
        if (presetNbt == null) {
            presetNbt = entityNbt;
        }
        this.type = SlotType.getByName(presetNbt.m_128461_("slot_type"));
        this.pos = UtilParse.readVec3((CompoundTag)presetNbt, (String)"slot_pos");
        this.zRot = presetNbt.m_128457_("zRot");
        this.onlyCompatPart = presetNbt.m_128461_("onlyCompatPart");
        this.linkedHitbox = presetNbt.m_128461_("linkedHitbox");
    }

    public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("name", this.slotId);
        tag.m_128359_("slot_type", this.type.getSlotTypeName());
        UtilParse.writeVec3((CompoundTag)tag, (Vec3)this.pos, (String)"slot_pos");
        tag.m_128350_("zRot", this.zRot);
        tag.m_128379_("locked", this.locked);
        tag.m_128359_("onlyCompatPart", this.onlyCompatPart);
        tag.m_128359_("linkedHitbox", this.linkedHitbox);
        if (this.filled()) {
            tag.m_128365_("data", (Tag)this.data.writeNBT());
        }
        return tag;
    }

    public PartSlot(FriendlyByteBuf buffer) {
        this.slotId = buffer.m_130277_();
        this.type = SlotType.getByName(buffer.m_130277_());
        this.pos = (Vec3)DataSerializers.VEC3.m_6709_(buffer);
        this.zRot = buffer.readFloat();
        this.locked = buffer.readBoolean();
        this.onlyCompatPart = buffer.m_130277_();
        this.linkedHitbox = buffer.m_130277_();
        boolean notNull = buffer.readBoolean();
        if (notNull) {
            this.data = (PartInstance)((Object)DataSerializers.PART_DATA.m_6709_(buffer));
        }
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.slotId);
        buffer.m_130070_(this.type.getSlotTypeName());
        DataSerializers.VEC3.m_6856_(buffer, (Object)this.pos);
        buffer.writeFloat(this.zRot);
        buffer.writeBoolean(this.locked);
        buffer.m_130070_(this.onlyCompatPart);
        buffer.m_130070_(this.linkedHitbox);
        buffer.writeBoolean(this.filled());
        if (this.filled()) {
            DataSerializers.PART_DATA.m_6856_(buffer, this.data);
        }
    }

    public Vec3 getRelPos() {
        return this.pos;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public final boolean filled() {
        return this.data != null;
    }

    @Nullable
    public PartInstance<?> getPartData() {
        return this.data;
    }

    public void serverSetup(EntityVehicle plane) {
        if (this.filled() && this.data.canSetup()) {
            this.data.setup(plane, this.slotId, this.pos);
        }
    }

    public void clientSetup(EntityVehicle plane) {
        if (this.filled() && this.data.canSetup()) {
            this.data.setup(plane, this.slotId, this.pos);
        }
    }

    protected void serverTick() {
        if (this.filled()) {
            this.data.tick(this.slotId);
        }
    }

    protected void clientTick() {
        if (this.filled()) {
            this.data.clientTick(this.slotId);
        }
    }

    public boolean dropPartItem(EntityVehicle parent) {
        if (parent.f_19853_.f_46443_) {
            return false;
        }
        if (!this.filled()) {
            return false;
        }
        UtilEntity.dropItemStack((Level)parent.f_19853_, (ItemStack)this.getPartData().getNewItemStack(), (Vec3)parent.convertRelPos(this.getRelPos()));
        return this.removePartData(parent);
    }

    public boolean addPartData(PartInstance<?> data, EntityVehicle plane) {
        if (this.filled()) {
            return false;
        }
        if (!this.isCompatible(data)) {
            return false;
        }
        this.data = data;
        if (plane == null) {
            return true;
        }
        if (data.canSetup()) {
            data.setup(plane, this.slotId, this.pos);
        }
        if (!plane.f_19853_.f_46443_) {
            PacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> plane), (Object)new ToClientAddPart(plane.m_19879_(), this.slotId, data));
        }
        return true;
    }

    public boolean removePartData(EntityVehicle plane) {
        if (!this.filled()) {
            return false;
        }
        this.data.remove(plane, this.slotId);
        if (!plane.f_19853_.f_46443_) {
            PacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> plane), (Object)new ToClientRemovePart(plane.m_19879_(), this.slotId));
        }
        this.data = null;
        return true;
    }

    public boolean setPartDamaged(EntityVehicle vehicle) {
        if (!this.filled()) {
            return false;
        }
        if (this.data.isDamaged()) {
            return true;
        }
        this.data.onDamaged(vehicle, this.slotId);
        return true;
    }

    public boolean canGetDamaged() {
        return this.filled() && !this.isNormalSeat() && !this.getPartData().isDamaged();
    }

    public boolean setPartRepaired(EntityVehicle vehicle) {
        if (!this.filled()) {
            return false;
        }
        if (!this.data.isDamaged()) {
            return true;
        }
        this.data.onRepaired(vehicle, this.slotId, this.pos);
        return true;
    }

    public void checkDirtyToSync(EntityVehicle vehicle) {
        if (this.getPartData() == null) {
            return;
        }
        if (!vehicle.m_9236_().m_5776_() && this.data.isDirty()) {
            PacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> vehicle), (Object)new ToClientSyncPart(vehicle, this.getPartData()));
            this.getPartData().onSendClientSync();
        }
    }

    public boolean isSeat() {
        if (this.data != null) {
            return ((PartStats)this.data.getStats()).isSeat();
        }
        return false;
    }

    public boolean isNormalSeat() {
        if (this.data != null) {
            return ((PartStats)this.data.getStats()).getType().is((JsonPresetType)PartType.SEAT);
        }
        return false;
    }

    public boolean isOnlyCompatWithOnePart() {
        return !this.onlyCompatPart.isEmpty();
    }

    public String getOnlyCompatPartId() {
        return this.onlyCompatPart;
    }

    public boolean isCompatible(PartInstance<?> data) {
        if (data == null) {
            return false;
        }
        if (this.isOnlyCompatWithOnePart()) {
            return data.getStatsId().equals(this.getOnlyCompatPartId());
        }
        return data.isCompatible(this.getSlotType());
    }

    public static String getSlotId(String slotId) {
        if (slotId.startsWith("slotname.dscombat.")) {
            return slotId.substring("slotname.dscombat.".length(), slotId.length());
        }
        if (slotId.startsWith("dscombat.")) {
            return slotId.substring("dscombat.".length(), slotId.length());
        }
        return slotId;
    }

    public String getSlotId() {
        return PartSlot.getSlotId(this.slotId);
    }

    public String getTranslatableName() {
        if (this.slotId.startsWith("slotname.dscombat.")) {
            return this.slotId;
        }
        if (this.slotId.startsWith("dscombat.")) {
            return "slotname." + this.slotId;
        }
        return "slotname.dscombat." + this.slotId;
    }

    public SlotType getSlotType() {
        return this.type;
    }

    public String toString() {
        return "[" + this.slotId + ":" + this.getSlotType().toString() + ":" + String.valueOf(this.data) + "]";
    }

    public float getZRot() {
        return this.zRot;
    }

    public boolean isPilotSlot() {
        return PartSlot.isPilotSeat(this.getSlotId());
    }

    public boolean isCoPilotSlot() {
        return PartSlot.isCoPilotSeat(this.getSlotId());
    }

    public static boolean isPilotSeat(String slotId) {
        return slotId.equals(PILOT_SLOT_NAME) || slotId.equals("dscombat.pilot_seat") || slotId.equals("slotname.dscombat.pilot_seat");
    }

    public static boolean isCoPilotSeat(String slotId) {
        return slotId.equals(COPILOT_SLOT_NAME);
    }

    public String getLinkedHitbox() {
        return this.linkedHitbox;
    }

    public boolean isLinkedWithVehicleRoot() {
        return this.linkedHitbox.isEmpty();
    }

    public boolean isLinkedToHitbox(String hitboxName) {
        return this.linkedHitbox.equals(hitboxName);
    }
}

