/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.parts;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public class SlotType {
    protected static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<String, SlotType> slotTypes = new HashMap<String, SlotType>();
    public static SlotType EXTERNAL = SlotType.registerExternalSlotType("external");
    public static SlotType EXTERNAL_TOUGH = SlotType.registerExternalSlotType("external_tough", EXTERNAL);
    public static SlotType SEAT = SlotType.registerSlotType("seat", EXTERNAL);
    public static SlotType MOUNT_LIGHT = SlotType.registerExternalSlotType("mount_light", SEAT);
    public static SlotType MOUNT_MED = SlotType.registerExternalSlotType("mount_med", MOUNT_LIGHT, EXTERNAL_TOUGH);
    public static SlotType MOUNT_HEAVY = SlotType.registerExternalSlotType("mount_heavy", MOUNT_MED);
    public static SlotType MOUNT_SUPER_HEAVY = SlotType.registerExternalSlotType("mount_super_heavy", MOUNT_HEAVY);
    public static SlotType MOUNT_TECH = SlotType.registerExternalSlotType("mount_tech", MOUNT_LIGHT);
    public static SlotType PYLON_LIGHT = SlotType.registerExternalSlotType("pylon_light", EXTERNAL);
    public static SlotType PYLON_MED = SlotType.registerExternalSlotType("pylon_med", PYLON_LIGHT);
    public static SlotType PYLON_HEAVY = SlotType.registerExternalSlotType("pylon_heavy", PYLON_MED, EXTERNAL_TOUGH);
    public static SlotType INTERNAL = SlotType.registerSlotType("internal");
    public static SlotType TECH_INTERNAL = SlotType.registerSlotType("tech_internal", INTERNAL);
    public static SlotType HIGH_TECH_INTERNAL = SlotType.registerSlotType("high_tech_internal", TECH_INTERNAL);
    public static SlotType INTERNAL_GUN = SlotType.registerSlotType("internal_gun", INTERNAL);
    public static SlotType SPIN_ENGINE = SlotType.registerSlotType("spin_engine", INTERNAL);
    public static SlotType PUSH_ENGINE = SlotType.registerSlotType("push_engine", INTERNAL);
    public static SlotType RADIAL_ENGINE = SlotType.registerSlotType("radial_engine", INTERNAL);
    private final String slotTypeName;
    private final SlotType[] parents;
    private final ResourceLocation bg_texture;
    private final boolean isExternal;
    private String[] children = new String[0];

    public static SlotType registerSlotType(SlotType type) {
        slotTypes.put(type.slotTypeName, type);
        return type;
    }

    public static SlotType registerSlotType(String name, SlotType ... parents) {
        return SlotType.registerSlotType(new SlotType(name, false, parents));
    }

    public static SlotType registerSlotType(String name) {
        return SlotType.registerSlotType(new SlotType(name));
    }

    public static SlotType registerExternalSlotType(String name, SlotType ... parents) {
        return SlotType.registerSlotType(new SlotType(name, true, parents));
    }

    public static SlotType registerExternalSlotType(String name) {
        return SlotType.registerSlotType(new SlotType(name, true, new SlotType[0]));
    }

    @Nullable
    public static SlotType getByName(String name) {
        if (!slotTypes.containsKey(name)) {
            return SlotType.checkOldNames(name);
        }
        return slotTypes.get(name);
    }

    @Nullable
    public static SlotType checkOldNames(String name) {
        return switch (name) {
            case "wing" -> PYLON_LIGHT;
            case "advanced_internal" -> TECH_INTERNAL;
            case "frame", "light_turret" -> MOUNT_LIGHT;
            case "heavy_frame", "heavy_turret" -> MOUNT_HEAVY;
            case "advanced_frame" -> MOUNT_TECH;
            case "med_turret" -> MOUNT_MED;
            default -> INTERNAL;
        };
    }

    @Nullable
    public static SlotType getByOldOrdinal(int o) {
        return switch (o) {
            case 0 -> SEAT;
            case 1 -> PYLON_HEAVY;
            case 2 -> MOUNT_LIGHT;
            case 4 -> HIGH_TECH_INTERNAL;
            case 5 -> MOUNT_MED;
            case 6, 9 -> MOUNT_HEAVY;
            case 7 -> SPIN_ENGINE;
            case 8 -> PUSH_ENGINE;
            case 10 -> RADIAL_ENGINE;
            default -> INTERNAL;
        };
    }

    public static void updateSlotTypeChildren() {
        LOGGER.debug("UPDATE SLOT TYPE CHILDREN");
        slotTypes.forEach((name, type) -> {
            ArrayList<String> children = new ArrayList<String>();
            SlotType.fillChildren(type, children);
            type.children = children.toArray(new String[children.size()]);
            LOGGER.debug(name + " : " + Arrays.toString(type.children));
        });
    }

    private static void fillChildren(SlotType parent, List<String> children) {
        slotTypes.forEach((name, type) -> {
            if (!type.hasParent(parent)) {
                return;
            }
            children.add((String)name);
            SlotType.fillChildren(type, children);
        });
    }

    public SlotType(String slotTypeName, boolean isExternal, SlotType ... parents) {
        this.slotTypeName = slotTypeName;
        this.parents = parents;
        this.isExternal = isExternal;
        this.bg_texture = new ResourceLocation("dscombat:textures/ui/slots/" + slotTypeName + ".png");
    }

    public SlotType(String slotTypeName) {
        this(slotTypeName, false, new SlotType[0]);
    }

    public String getSlotTypeName() {
        return this.slotTypeName;
    }

    public boolean isChild() {
        return this.parents.length > 0;
    }

    private boolean hasParent(SlotType parent) {
        for (int i = 0; i < this.parents.length; ++i) {
            if (!this.parents[i].is(parent)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getSlotTypeName();
    }

    public ResourceLocation getBgTexture() {
        return this.bg_texture;
    }

    public String getTranslatableName() {
        return "slottype.dscombat." + this.slotTypeName;
    }

    public boolean is(SlotType type) {
        return this.getSlotTypeName().equals(type.getSlotTypeName());
    }

    public boolean isCompatible(SlotType type) {
        if (type == null) {
            return false;
        }
        if (this.is(type)) {
            return true;
        }
        for (int i = 0; i < this.children.length; ++i) {
            if (!this.children[i].equals(type.getSlotTypeName())) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o instanceof SlotType) {
            SlotType type = (SlotType)o;
            return this.is(type);
        }
        return false;
    }

    public boolean isExternal() {
        return this.isExternal;
    }
}

