/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.parts.client;

import com.google.gson.JsonObject;
import com.onewhohears.dscombat.client.model.obj.ObjPartModel;
import com.onewhohears.dscombat.client.model.obj.ObjWeaponRackModel;
import com.onewhohears.dscombat.data.parts.client.PartClientStats;
import com.onewhohears.dscombat.data.parts.client.PartClientType;
import com.onewhohears.dscombat.entity.parts.EntityWeaponRack;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetType;
import com.onewhohears.onewholibs.util.UtilParse;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class WeaponRackClientStats
extends PartClientStats<EntityWeaponRack> {
    private final int maxAmmoNum;
    private final Vec3[] weapon_pos;

    public WeaponRackClientStats(ResourceLocation key, JsonObject json) {
        super(key, json);
        if (json.has("weapon_pos")) {
            this.weapon_pos = UtilParse.readVec3Array((JsonObject)json, (String)"weapon_pos");
            this.maxAmmoNum = this.weapon_pos.length;
        } else {
            this.maxAmmoNum = UtilParse.getIntSafe((JsonObject)json, (String)"maxAmmoNum", (int)0);
            this.weapon_pos = new Vec3[this.maxAmmoNum];
            float dX = UtilParse.getFloatSafe((JsonObject)json, (String)"dX", (float)0.0f);
            float dY = UtilParse.getFloatSafe((JsonObject)json, (String)"dY", (float)0.0f);
            for (int i = 0; i < this.maxAmmoNum; ++i) {
                float x = i % 2 == 0 ? dX : -dX;
                float y = (float)(i / 2 + 1) * dY - dY * 0.5f;
                if (i + 1 == this.maxAmmoNum && this.maxAmmoNum % 2 == 1) {
                    x = 0.0f;
                }
                this.weapon_pos[i] = new Vec3((double)x, (double)y, 0.0);
            }
        }
    }

    @Override
    protected ObjPartModel<EntityWeaponRack> createNotHardCodedModel() {
        return new ObjWeaponRackModel<EntityWeaponRack>(this.getModelId(), this.getMaxAmmoNum(), this.getWeaponPositions());
    }

    @Override
    public JsonPresetType getType() {
        return PartClientType.WEAPON_RACK;
    }

    public int getMaxAmmoNum() {
        return this.maxAmmoNum;
    }

    public Vec3[] getWeaponPositions() {
        return this.weapon_pos;
    }
}

