/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.parts.stats;

import com.google.gson.JsonObject;
import com.onewhohears.dscombat.data.parts.PartType;
import com.onewhohears.dscombat.data.parts.instance.WeaponPartInstance;
import com.onewhohears.dscombat.data.parts.stats.PartStats;
import com.onewhohears.dscombat.data.weapon.WeaponPresets;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetInstance;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetType;
import com.onewhohears.onewholibs.util.UtilParse;
import java.util.List;
import net.minecraft.resources.ResourceLocation;

public class WeaponPartStats
extends PartStats {
    private final String[] compatible;
    private final int max;

    public WeaponPartStats(ResourceLocation key, JsonObject json) {
        super(key, json);
        List<String> list = WeaponPresets.get().getCompatibleWeapons(this.getId());
        this.compatible = list.toArray(new String[list.size()]);
        this.max = UtilParse.getIntSafe((JsonObject)json, (String)"max", (int)0);
    }

    public JsonPresetType getType() {
        return PartType.INTERNAL_WEAPON;
    }

    public JsonPresetInstance<?> createPresetInstance() {
        return new WeaponPartInstance<WeaponPartStats>(this);
    }

    public boolean isWeaponCompatible(String preset) {
        if (preset == null) {
            return false;
        }
        for (int i = 0; i < this.compatible.length; ++i) {
            if (!this.compatible[i].equals(preset)) continue;
            return true;
        }
        return false;
    }

    public int getMaxAmmo() {
        return this.max;
    }
}

