/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.vehicle;

import java.util.HashMap;
import java.util.Map;

@Deprecated
public class LiftKGraph {
    private static final int[] ALEXIS_PLANE_DEGRESS = new int[]{-36, -34, -32, -30, -28, -26, -24, -22, -20, -18, -16, -14, -12, -10, -8, -6, -4, -2, 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26, 28, 30, 32, 34, 36};
    private static final float[] ALEXIS_PLANE_LIFT = new float[]{0.0f, -0.4f, -0.78f, -1.04f, -1.18f, -1.2f, -1.18f, -1.15f, -1.11f, -1.06f, -0.99f, -0.89f, -0.79f, -0.68f, -0.58f, -0.48f, -0.36f, -0.2f, 0.0f, 0.2f, 0.36f, 0.48f, 0.58f, 0.68f, 0.79f, 0.89f, 0.99f, 1.06f, 1.11f, 1.15f, 1.18f, 1.2f, 1.18f, 1.04f, 0.78f, 0.4f, 0.0f};
    public static final LiftKGraph ALEXIS_PLANE_GRAPH = new LiftKGraph("alexis_plane", ALEXIS_PLANE_DEGRESS, ALEXIS_PLANE_LIFT);
    private static final int[] JAVI_PLANE_DEGRESS = new int[]{-26, -24, -22, -20, -18, -16, -14, -12, -10, -8, -6, -4, -2, 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26};
    private static final float[] JAVI_PLANE_LIFT = new float[]{0.0f, -0.18f, -0.36f, -0.47f, -0.55f, -0.58f, -0.53f, -0.43f, -0.32f, -0.2f, -0.05f, 0.1f, 0.25f, 0.4f, 0.5f, 0.68f, 0.79f, 0.9f, 1.01f, 1.12f, 1.2f, 1.28f, 1.3f, 1.28f, 1.15f, 0.7f, 0.0f};
    public static final LiftKGraph JAVI_PLANE_GRAPH = new LiftKGraph("javi_plane", JAVI_PLANE_DEGRESS, JAVI_PLANE_LIFT);
    private static final int[] WOODEN_PLANE_DEGRESS = new int[]{-20, -18, -17, -16, -15, -14, -13, -12, -10, -8, -6, -4, -2, 0, 2, 4, 6, 8, 10, 12, 13, 14, 15, 16, 17, 18, 20};
    private static final float[] WOODEN_PLANE_LIFT = new float[]{0.0f, -0.72f, -0.92f, -1.02f, -1.04f, -1.02f, -0.98f, -0.94f, -0.82f, -0.68f, -0.57f, -0.4f, -0.2f, 0.0f, 0.2f, 0.4f, 0.57f, 0.68f, 0.82f, 0.94f, 0.98f, 1.02f, 1.04f, 1.02f, 0.92f, 0.71f, 0.0f};
    public static final LiftKGraph WOODEN_PLANE_GRAPH = new LiftKGraph("wooden_plane", WOODEN_PLANE_DEGRESS, WOODEN_PLANE_LIFT);
    private static final int[] E3SENTRY_PLANE_DEGRESS = new int[]{-26, -24, -22, -20, -18, -16, -14, -12, -10, -8, -6, -4, -2, 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 26};
    private static final float[] E3SENTRY_PLANE_LIFT = new float[]{0.0f, -0.18f, -0.36f, -0.47f, -0.55f, -0.58f, -0.53f, -0.43f, -0.32f, -0.2f, -0.05f, 0.1f, 0.2f, 0.3f, 0.42f, 0.54f, 0.64f, 0.75f, 0.86f, 0.96f, 1.02f, 1.08f, 1.1f, 1.06f, 0.96f, 0.65f, 0.0f};
    public static final LiftKGraph E3SENTRY_PLANE_GRAPH = new LiftKGraph("e3sentry_plane", E3SENTRY_PLANE_DEGRESS, E3SENTRY_PLANE_LIFT);
    private static final Map<String, LiftKGraph> aoaGraphs = new HashMap<String, LiftKGraph>();
    public final String id;
    private final int[] aoa;
    private final float[] lift;
    private final int criticalAOA;
    private final int warnAOA;

    public static void registerAOAGraph(LiftKGraph graph) {
        aoaGraphs.put(graph.id, graph);
    }

    public static LiftKGraph getGraphById(String id) {
        if (!aoaGraphs.containsKey(id)) {
            return WOODEN_PLANE_GRAPH;
        }
        return aoaGraphs.get(id);
    }

    public LiftKGraph(String id, int[] aoa, float[] lift) {
        this.id = id;
        if (aoa.length != lift.length) {
            this.aoa = new int[]{0};
            this.lift = new float[]{0.0f};
            this.criticalAOA = 0;
            this.warnAOA = 0;
            return;
        }
        this.aoa = aoa;
        this.lift = lift;
        this.criticalAOA = this.findCriticalAOA();
        this.warnAOA = (int)((float)this.criticalAOA * 0.5f);
    }

    public float getLift(float aoaDegrees) {
        int maxI;
        int minI = this.getMinIndex(aoaDegrees);
        if (minI == (maxI = this.getMaxIndex(aoaDegrees))) {
            return this.lift[minI];
        }
        float d = aoaDegrees - (float)this.aoa[minI];
        return d * (this.lift[maxI] - this.lift[minI]) / (float)(this.aoa[maxI] - this.aoa[minI]) + this.lift[minI];
    }

    private int getMinIndex(float degrees) {
        int deg = (int)Math.floor(degrees);
        for (int i = 1; i < this.aoa.length; ++i) {
            if (this.aoa[i] <= deg) continue;
            return i - 1;
        }
        return this.aoa.length - 1;
    }

    private int getMaxIndex(float degrees) {
        int deg = (int)Math.ceil(degrees);
        for (int i = this.aoa.length - 2; i >= 0; --i) {
            if (this.aoa[i] >= deg) continue;
            return i + 1;
        }
        return 0;
    }

    private int findCriticalAOA() {
        for (int i = 1; i < this.aoa.length - 1; ++i) {
            if (this.aoa[i] < 0 || !(this.lift[i - 1] < this.lift[i]) || !(this.lift[i + 1] < this.lift[i])) continue;
            return this.aoa[i];
        }
        return 0;
    }

    public int getCriticalAOA() {
        return this.criticalAOA;
    }

    public int getWarnAOA() {
        return this.warnAOA;
    }

    static {
        LiftKGraph.registerAOAGraph(ALEXIS_PLANE_GRAPH);
        LiftKGraph.registerAOAGraph(JAVI_PLANE_GRAPH);
        LiftKGraph.registerAOAGraph(WOODEN_PLANE_GRAPH);
        LiftKGraph.registerAOAGraph(E3SENTRY_PLANE_GRAPH);
    }
}

