/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.vehicle.physics;

import com.google.gson.JsonObject;
import com.mojang.math.Vector3f;
import com.onewhohears.dscombat.data.graph.AoaLiftKGraph;
import com.onewhohears.dscombat.data.graph.FloatFloatGraph;
import com.onewhohears.dscombat.data.graph.StatGraphs;
import com.onewhohears.dscombat.data.vehicle.physics.LiftSurfaceInstance;
import com.onewhohears.dscombat.data.vehicle.physics.PhysicsComponentData;
import com.onewhohears.dscombat.data.vehicle.physics.PhysicsComponentInstance;
import com.onewhohears.dscombat.entity.PhysicsBody;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetReloader;
import com.onewhohears.onewholibs.data.jsonpreset.PresetStatsHolder;
import com.onewhohears.onewholibs.util.UtilParse;
import java.util.function.BiFunction;
import net.minecraft.world.phys.Vec3;

public class LiftSurfaceData
extends PhysicsComponentData {
    private final boolean ignore_roll;
    private final float input_rotation_max;
    private final double area;
    private final double zero_lift_drag;
    private final Vector3f rotation;
    private final InputType input_type;
    private final String lift_k_graph_key;
    private final String drag_graph_key;
    private PresetStatsHolder<?> lift_k_graph;
    private PresetStatsHolder<?> drag_graph;

    public static JsonObject createJsonData(String hitbox, boolean ignore_roll, float input_rotation_max, double area, Vec3 pos, float xRot, float yRot, float zRot, InputType input_type, String lift_k_graph, String drag_graph, double zero_lift_drag) {
        JsonObject json = new JsonObject();
        json.addProperty("id", "lift_surface");
        json.addProperty("hitbox", hitbox);
        json.addProperty("ignore_roll", Boolean.valueOf(ignore_roll));
        json.addProperty("input_rotation_max", (Number)Float.valueOf(input_rotation_max));
        json.addProperty("area", (Number)area);
        UtilParse.writeVec3((JsonObject)json, (String)"pos", (Vec3)pos);
        UtilParse.writeVec3f((JsonObject)json, (String)"rotation", (Vector3f)new Vector3f(xRot, yRot, zRot));
        UtilParse.writeEnum((JsonObject)json, (String)"input_type", (Enum)input_type);
        json.addProperty("lift_k_graph", lift_k_graph);
        json.addProperty("drag_graph", drag_graph);
        json.addProperty("zero_lift_drag", (Number)zero_lift_drag);
        return json;
    }

    public LiftSurfaceData(JsonObject json) {
        super(json);
        this.ignore_roll = UtilParse.getBooleanSafe((JsonObject)json, (String)"ignore_roll", (boolean)false);
        this.input_rotation_max = UtilParse.getFloatSafe((JsonObject)json, (String)"input_rotation_max", (float)4.0f);
        this.area = UtilParse.getFloatSafe((JsonObject)json, (String)"area", (float)10.0f);
        this.rotation = UtilParse.readVec3f((JsonObject)json, (String)"rotation");
        this.input_type = (InputType)UtilParse.getEnumSafe((JsonObject)json, (String)"input_type", InputType.class);
        this.lift_k_graph_key = UtilParse.getStringSafe((JsonObject)json, (String)"lift_k_graph", (String)"fuselage");
        this.zero_lift_drag = UtilParse.getFloatSafe((JsonObject)json, (String)"zero_lift_drag", (float)0.5f);
        this.drag_graph_key = UtilParse.getStringSafe((JsonObject)json, (String)"drag_graph", (String)"default_drag_aoa");
    }

    @Override
    public PhysicsComponentInstance<?> createInstance() {
        return new LiftSurfaceInstance(this);
    }

    public AoaLiftKGraph getLiftKGraph() {
        if (this.lift_k_graph == null) {
            this.lift_k_graph = new PresetStatsHolder((JsonPresetReloader)StatGraphs.get(), this.lift_k_graph_key);
        }
        return (AoaLiftKGraph)this.lift_k_graph.get();
    }

    public FloatFloatGraph getDragGraph() {
        if (this.drag_graph == null) {
            this.drag_graph = new PresetStatsHolder((JsonPresetReloader)StatGraphs.get(), this.drag_graph_key);
        }
        return (FloatFloatGraph)this.drag_graph.get();
    }

    public double getArea() {
        return this.area;
    }

    public double getZeroLiftDrag() {
        return this.zero_lift_drag;
    }

    public Vector3f getRotation() {
        return this.rotation;
    }

    public boolean isIgnoreRoll() {
        return this.ignore_roll;
    }

    public float getInputRotationMax() {
        return this.input_rotation_max;
    }

    public InputType getInputType() {
        return this.input_type;
    }

    public static enum InputType {
        NONE((surface, body) -> Float.valueOf(0.0f)),
        LEFT_FLAP((surface, body) -> {
            if (body.isFlapsDown()) {
                return Float.valueOf(surface.getInputRotationMax());
            }
            return Float.valueOf(body.getRollInput() * surface.getInputRotationMax() * 0.5f);
        }),
        RIGHT_FLAP((surface, body) -> {
            if (body.isFlapsDown()) {
                return Float.valueOf(surface.getInputRotationMax());
            }
            return Float.valueOf(-body.getRollInput() * surface.getInputRotationMax() * 0.5f);
        }),
        ELEVATOR((surface, body) -> Float.valueOf(-body.getPitchInput() * surface.getInputRotationMax())),
        STABILIZER((surface, body) -> Float.valueOf(body.getYawInput() * surface.getInputRotationMax()));

        private final BiFunction<LiftSurfaceData, PhysicsBody, Float> input;

        private InputType(BiFunction<LiftSurfaceData, PhysicsBody, Float> input) {
            this.input = input;
        }

        public float getRotationFromInput(LiftSurfaceData liftSurface, PhysicsBody body) {
            return this.input.apply(liftSurface, body).floatValue();
        }
    }
}

