/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.vehicle.physics;

import com.mojang.logging.LogUtils;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.onewhohears.dscombat.data.vehicle.physics.LiftSurfaceData;
import com.onewhohears.dscombat.data.vehicle.physics.PhysicsComponentInstance;
import com.onewhohears.dscombat.entity.PhysicsBody;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class LiftSurfaceInstance
extends PhysicsComponentInstance<LiftSurfaceData> {
    protected static final Logger LOGGER = LogUtils.getLogger();
    private float aoa = 0.0f;
    private Vec3 dragForce = Vec3.f_82478_;
    private Vec3 liftForce = Vec3.f_82478_;

    public LiftSurfaceInstance(LiftSurfaceData data) {
        super(data);
    }

    @Override
    protected void calcPhysics(PhysicsBody body) {
        float rotate;
        Quaternion vehicleQ;
        if (((LiftSurfaceData)this.getData()).isIgnoreRoll()) {
            vehicleQ = Quaternion.f_80118_.m_80161_();
            vehicleQ.m_80148_(Vector3f.f_122223_.m_122240_(body.m_146909_()));
            vehicleQ.m_80148_(Vector3f.f_122225_.m_122240_(body.m_146908_()));
        } else {
            vehicleQ = body.getQBySide().m_80161_();
        }
        Quaternion surfaceQ = vehicleQ.m_80161_();
        Vector3f rotation = ((LiftSurfaceData)this.getData()).getRotation();
        if (rotation.m_122239_() != 0.0f) {
            surfaceQ.m_80148_(Vector3f.f_122222_.m_122240_(rotation.m_122239_()));
        }
        if (rotation.m_122260_() != 0.0f) {
            surfaceQ.m_80148_(Vector3f.f_122225_.m_122240_(rotation.m_122260_()));
        }
        if (rotation.m_122269_() != 0.0f) {
            surfaceQ.m_80148_(Vector3f.f_122227_.m_122240_(rotation.m_122269_()));
        }
        if ((rotate = ((LiftSurfaceData)this.getData()).getInputType().getRotationFromInput((LiftSurfaceData)this.getData(), body)) != 0.0f) {
            surfaceQ.m_80148_(Vector3f.f_122222_.m_122240_(rotate));
        }
        Vec3 u = body.m_20184_();
        Vec3 pitchAxis = UtilAngles.getPitchAxis((Quaternion)surfaceQ);
        Vec3 liftDir = u.m_82537_(pitchAxis).m_82541_();
        Vec3 airFoilAxes = UtilAngles.getRollAxis((Quaternion)surfaceQ);
        float airFoilSpeedSqr = (float)UtilGeometry.vecCompByNormAxis((Vec3)u, (Vec3)airFoilAxes).m_82556_() * 400.0f;
        Vec3 wingNormal = UtilAngles.getYawAxis((Quaternion)surfaceQ).m_82490_(-1.0);
        float goalAOA = UtilGeometry.isZero((Vec3)u) ? 0.0f : LiftSurfaceInstance.calcAOA(u, wingNormal);
        this.aoa = Mth.m_14179_((float)LiftSurfaceInstance.getAOAChangeRate(body), (float)this.aoa, (float)goalAOA);
        float speedScaleSqr = (float)(1.0 / body.getHorizontalSpeedScale() / body.getHorizontalSpeedScale());
        float liftK = this.getLiftK(this.aoa) * speedScaleSqr;
        double P = this.getAirDensity(body);
        double wingLiftMag = 0.5 * (double)liftK * P * (double)airFoilSpeedSqr * ((LiftSurfaceData)this.getData()).getArea();
        this.liftForce = liftDir.m_82490_(wingLiftMag);
        body.addForce(this.liftForce);
        Quaternion vehicleQI = vehicleQ.m_80161_();
        vehicleQI.m_80157_();
        Vec3 liftMoment = ((LiftSurfaceData)this.getData()).getPos().m_82537_(UtilAngles.rotateVector((Vec3)this.liftForce, (Quaternion)vehicleQI)).m_82542_(-1.0, 1.0, 1.0);
        body.addMoment(liftMoment, true, true);
        Vec3 windDir = u.m_82541_();
        float dragK = this.getDragK(this.aoa) * speedScaleSqr;
        if (dragK < 0.0f) {
            LOGGER.warn("Drag Coefficient is somehow negative. Should not happen! Is the drag graph setup correctly? graph_id = {} aoa = {}", (Object)((LiftSurfaceData)this.getData()).getDragGraph().getId(), (Object)Float.valueOf(this.aoa));
        }
        double dragMag = 0.5 * (double)dragK * P * (double)airFoilSpeedSqr * ((LiftSurfaceData)this.getData()).getArea() * ((LiftSurfaceData)this.getData()).getZeroLiftDrag();
        this.dragForce = windDir.m_82490_(-dragMag);
        body.addDragForce(this.dragForce);
        Vec3 dragMoment = ((LiftSurfaceData)this.getData()).getPos().m_82537_(UtilAngles.rotateVector((Vec3)this.dragForce, (Quaternion)vehicleQI)).m_82542_(-1.0, 1.0, 1.0);
        body.addMoment(dragMoment, false, true);
    }

    @Override
    protected boolean canCalcPhysics(PhysicsBody body) {
        if (!super.canCalcPhysics(body)) {
            return false;
        }
        return !body.isArcadeMode();
    }

    @Override
    public Vec3 getDragForce() {
        return this.dragForce;
    }

    @Override
    public Vec3 getLiftForce() {
        return this.liftForce;
    }

    @Override
    public float getAOA() {
        return this.aoa;
    }

    protected float getLiftK(float aoa) {
        CompoundTag value;
        if (this.getWindTunnel() != null && (value = this.getWindTunnel().getOverrideValue("lift_coefficient")) != null) {
            double AOA = value.m_128459_("aoa");
            double liftC = value.m_128459_("liftC");
            if (Math.abs((double)aoa - AOA) < 0.1) {
                return (float)liftC;
            }
        }
        return ((LiftSurfaceData)this.getData()).getLiftKGraph().getLerpFloat(aoa);
    }

    protected float getDragK(float aoa) {
        CompoundTag value;
        if (this.getWindTunnel() != null && (value = this.getWindTunnel().getOverrideValue("drag_coefficient")) != null) {
            double AOA = value.m_128459_("aoa");
            double dragC = value.m_128459_("dragC");
            if (Math.abs((double)aoa - AOA) < 0.1) {
                return (float)dragC;
            }
        }
        return ((LiftSurfaceData)this.getData()).getDragGraph().getLerpFloat(aoa);
    }

    protected double getAirDensity(PhysicsBody body) {
        return body.getAirDensity();
    }

    public static float calcAOA(Vec3 u, Vec3 wingNormal) {
        return (float)UtilGeometry.angleBetweenVecPlaneDegrees((Vec3)u, (Vec3)wingNormal);
    }

    public static float getAOAChangeRate(PhysicsBody body) {
        if (body.isTestMode()) {
            return 1.0f;
        }
        return 0.5f;
    }
}

