/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.vehicle.physics;

import com.onewhohears.dscombat.data.vehicle.physics.PhysicsComponentData;
import com.onewhohears.dscombat.entity.PhysicsBody;
import com.onewhohears.dscombat.entity.vehicle.wind_tunnel.EntityWindTunnel;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class PhysicsComponentInstance<D extends PhysicsComponentData> {
    private final D data;
    @Nullable
    private EntityWindTunnel tunnel = null;

    public PhysicsComponentInstance(D data) {
        this.data = data;
    }

    public void tick(PhysicsBody body) {
        if (this.canCalcPhysics(body)) {
            this.calcPhysics(body);
        }
    }

    protected boolean canCalcPhysics(PhysicsBody body) {
        if (body.isTestMode()) {
            return true;
        }
        if (((PhysicsComponentData)this.getData()).getHitbox().equals("NONE")) {
            return body.isOperational();
        }
        return !body.areAllHitboxesDead(((PhysicsComponentData)this.getData()).getHitbox());
    }

    protected abstract void calcPhysics(PhysicsBody var1);

    public D getData() {
        return this.data;
    }

    public abstract Vec3 getDragForce();

    public abstract Vec3 getLiftForce();

    public abstract float getAOA();

    @Nullable
    public EntityWindTunnel getWindTunnel() {
        return this.tunnel;
    }

    public void setWindTunnel(EntityWindTunnel tunnel) {
        this.tunnel = tunnel;
    }
}

