/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.villager;

import com.onewhohears.dscombat.init.ModItems;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class DSCVillagerTrades {
    public static void putWeaponEngineerTrades(Int2ObjectMap<List<VillagerTrades.ItemListing>> trades) {
        ((List)trades.get(1)).add(new ItemForEmerald((ItemLike)Items.f_151052_, 5, 1, 16, 2));
        ((List)trades.get(1)).add(new ItemForEmerald((ItemLike)Items.f_42403_, 4, 1, 16, 2));
        ((List)trades.get(1)).add(new EmeraldForItem((ItemLike)ModItems.B_20MM.get(), 4, 1, 30, 4));
        ((List)trades.get(1)).add(new EmeraldForItem((ItemLike)ModItems.B_50MMHE.get(), 1, 3, 30, 4));
        ((List)trades.get(2)).add(new EmeraldForItem((ItemLike)ModItems.B_120MMHE.get(), 1, 8, 30, 6));
        ((List)trades.get(2)).add(new EmeraldForAmmo((ItemLike)ModItems.BOMB.get(), "anm30", 4, 9, 20, 8));
        ((List)trades.get(2)).add(new EmeraldForAmmo((ItemLike)ModItems.BOMB.get(), "anm57", 2, 9, 20, 8));
        ((List)trades.get(2)).add(new EmeraldForAmmo((ItemLike)ModItems.BOMB.get(), "anm64", 1, 9, 20, 8));
        ((List)trades.get(3)).add(new EmeraldForItem((ItemLike)ModItems.AGM114K.get(), 1, 15, 10, 12));
        ((List)trades.get(3)).add(new EmeraldForItem((ItemLike)ModItems.AGM65L.get(), 1, 20, 10, 15));
        ((List)trades.get(3)).add(new EmeraldForItem((ItemLike)ModItems.AIM9L.get(), 1, 31, 10, 21));
        ((List)trades.get(4)).add(new EmeraldForItem((ItemLike)ModItems.AGM84E.get(), 1, 30, 10, 20));
        ((List)trades.get(4)).add(new EmeraldForItem((ItemLike)ModItems.AIM9P5.get(), 1, 43, 10, 26));
        ((List)trades.get(4)).add(new EmeraldForItem((ItemLike)ModItems.AIM7F.get(), 1, 38, 10, 22));
        ((List)trades.get(5)).add(new EmeraldForItem((ItemLike)ModItems.AGM88G.get(), 1, 50, 10, 24));
        ((List)trades.get(5)).add(new EmeraldForItem((ItemLike)ModItems.AIM9X.get(), 1, 55, 10, 24));
        ((List)trades.get(5)).add(new EmeraldForItem((ItemLike)ModItems.AIM120B.get(), 1, 70, 10, 24));
    }

    public static void putAircraftEngineerTrades(Int2ObjectMap<List<VillagerTrades.ItemListing>> trades) {
        ((List)trades.get(1)).add(new EmeraldRangeForItem((ItemLike)ModItems.COCKPIT.get(), 5, 7, 4, 4));
        ((List)trades.get(1)).add(new EmeraldRangeForItem((ItemLike)ModItems.LIGHT_FUEL_TANK.get(), 6, 8, 4, 4));
        ((List)trades.get(1)).add(new EmeraldRangeForItem((ItemLike)ModItems.C6_ENGINE.get(), 10, 14, 4, 5));
        ((List)trades.get(1)).add(new EmeraldRangeForItem((ItemLike)ModItems.CM_MANLY_52.get(), 8, 12, 4, 5));
        ((List)trades.get(2)).add(new EmeraldRangeForItem((ItemLike)ModItems.WOODEN_PLANE.get(), 20, 24, 2, 10));
        ((List)trades.get(2)).add(new EmeraldRangeForItem((ItemLike)ModItems.ORANGE_TESLA.get(), 16, 20, 2, 10));
        ((List)trades.get(2)).add(new EmeraldRangeForItem((ItemLike)ModItems.HEAVY_FUEL_TANK.get(), 10, 12, 4, 8));
        ((List)trades.get(2)).add(new EmeraldRangeForItem((ItemLike)ModItems.TURBOFAN_F25.get(), 14, 18, 4, 9));
        ((List)trades.get(3)).add(new EmeraldRangeForItem((ItemLike)ModItems.ADVANCED_COCKPIT.get(), 6, 8, 4, 15));
        ((List)trades.get(3)).add(new EmeraldRangeForItem((ItemLike)ModItems.TURBOFAN_F145.get(), 20, 24, 4, 16));
        ((List)trades.get(3)).add(new EmeraldRangeForItem((ItemLike)ModItems.CIWS.get(), 28, 32, 2, 17));
        ((List)trades.get(3)).add(new EmeraldRangeForItem((ItemLike)ModItems.STEVE_UP_SMASH.get(), 29, 33, 2, 18));
        ((List)trades.get(4)).add(new EmeraldForAircraft((ItemLike)ModItems.VEHICLE.get(), "felix_plane_unarmed", 78, 83, 2, 25));
        ((List)trades.get(4)).add(new EmeraldForAircraft((ItemLike)ModItems.VEHICLE.get(), "noah_chopper_unarmed", 50, 55, 2, 25));
        ((List)trades.get(4)).add(new EmeraldRangeForItem((ItemLike)ModItems.SAM_LAUNCHER.get(), 40, 45, 2, 20));
        ((List)trades.get(5)).add(new EmeraldForAircraft((ItemLike)ModItems.VEHICLE.get(), "javi_plane_unarmed", 101, 107, 2, 25));
        ((List)trades.get(5)).add(new EmeraldForAircraft((ItemLike)ModItems.VEHICLE.get(), "krait_chopper_unarmed", 65, 70, 2, 25));
        ((List)trades.get(5)).add(new EmeraldForAircraft((ItemLike)ModItems.VEHICLE.get(), "mrbudger_tank", 90, 96, 2, 25));
    }

    public static class ItemForEmerald
    implements VillagerTrades.ItemListing {
        protected final Item item;
        protected final int num;
        protected final int value;
        protected final int maxUses;
        protected final int villagerXp;
        protected final float priceMultiplier;

        public ItemForEmerald(ItemLike item, int num, int value, int maxUses, int villagerXp) {
            this.item = item.m_5456_();
            this.num = num;
            if (value > 64) {
                value = 64;
            } else if (value < 1) {
                value = 1;
            }
            this.value = value;
            this.maxUses = maxUses;
            this.villagerXp = villagerXp;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer m_213663_(Entity trader, RandomSource random) {
            ItemStack costA = new ItemStack((ItemLike)this.item, this.num);
            ItemStack result = new ItemStack((ItemLike)Items.f_42616_, this.value);
            return new MerchantOffer(costA, result, this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }

    public static class EmeraldForItem
    implements VillagerTrades.ItemListing {
        protected final Item item;
        protected final int num;
        protected final int cost;
        protected final int maxUses;
        protected final int villagerXp;
        protected final float priceMultiplier;

        public EmeraldForItem(ItemLike item, int num, int cost, int maxUses, int villagerXp) {
            this.item = item.m_5456_();
            this.num = num;
            if (cost > 128) {
                cost = 128;
            } else if (cost < 1) {
                cost = 1;
            }
            this.cost = cost;
            this.maxUses = maxUses;
            this.villagerXp = villagerXp;
            this.priceMultiplier = 0.05f;
        }

        public EmeraldForItem(ItemLike item, int cost, int maxUses, int villagerXp) {
            this(item, 1, cost, maxUses, villagerXp);
        }

        public int getCost(RandomSource random) {
            return this.cost;
        }

        public ItemStack getResult() {
            ItemStack stack = this.item.m_7968_();
            stack.m_41764_(this.num);
            return stack;
        }

        public MerchantOffer m_213663_(Entity trader, RandomSource random) {
            ItemStack costB;
            ItemStack costA;
            int emeralds = this.getCost(random);
            if (emeralds > 64) {
                costA = new ItemStack((ItemLike)Items.f_42616_, 64);
                costB = new ItemStack((ItemLike)Items.f_42616_, emeralds - 64);
            } else {
                costA = new ItemStack((ItemLike)Items.f_42616_, emeralds);
                costB = ItemStack.f_41583_;
            }
            return new MerchantOffer(costA, costB, this.getResult(), this.maxUses, this.villagerXp, this.priceMultiplier);
        }
    }

    public static class EmeraldForAmmo
    extends EmeraldForItem {
        protected final String weapon;

        public EmeraldForAmmo(ItemLike item, String weapon, int num, int cost, int maxUses, int villagerXp) {
            super(item, num, cost, maxUses, villagerXp);
            this.weapon = weapon;
        }

        @Override
        public ItemStack getResult() {
            ItemStack stack = super.getResult();
            CompoundTag nbt = stack.m_41784_();
            nbt.m_128359_("weapon", this.weapon);
            return stack;
        }
    }

    public static class EmeraldRangeForItem
    extends EmeraldForItem {
        protected final int maxCost;

        public EmeraldRangeForItem(ItemLike item, int minCost, int maxCost, int maxUses, int villagerXp) {
            super(item, 1, minCost, maxUses, villagerXp);
            if (maxCost > 128) {
                maxCost = 128;
            }
            this.maxCost = maxCost;
        }

        @Override
        public int getCost(RandomSource random) {
            return Mth.m_216271_((RandomSource)random, (int)this.cost, (int)this.maxCost);
        }
    }

    public static class EmeraldForAircraft
    extends EmeraldRangeForItem {
        protected final String preset;

        public EmeraldForAircraft(ItemLike item, String preset, int minCost, int maxCost, int maxUses, int villagerXp) {
            super(item, minCost, maxCost, maxUses, villagerXp);
            this.preset = preset;
        }

        @Override
        public ItemStack getResult() {
            ItemStack stack = super.getResult();
            CompoundTag nbt = stack.m_41784_();
            nbt.m_128359_("preset", this.preset);
            return stack;
        }
    }
}

