/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.weapon;

import com.onewhohears.dscombat.data.weapon.stats.AntiRadarMissileStats;
import com.onewhohears.dscombat.data.weapon.stats.BombStats;
import com.onewhohears.dscombat.data.weapon.stats.BulletStats;
import com.onewhohears.dscombat.data.weapon.stats.BunkerBusterStats;
import com.onewhohears.dscombat.data.weapon.stats.DumbTorpedoStats;
import com.onewhohears.dscombat.data.weapon.stats.IRMissileStats;
import com.onewhohears.dscombat.data.weapon.stats.NoWeaponStats;
import com.onewhohears.dscombat.data.weapon.stats.PosMissileStats;
import com.onewhohears.dscombat.data.weapon.stats.TorpedoStats;
import com.onewhohears.dscombat.data.weapon.stats.TrackMissileStats;
import com.onewhohears.dscombat.init.ModEntities;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetStats;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetType;
import net.minecraft.world.entity.EntityType;

public abstract class WeaponType
extends JsonPresetType {
    public static final None NONE = None.INSTANCE;
    public static final Bullet BULLET = Bullet.INSTANCE;
    public static final Bomb BOMB = Bomb.INSTANCE;
    public static final BunkerBuster BUNKER_BUSTER = BunkerBuster.INSTANCE;
    public static final IrMissile IR_MISSILE = IrMissile.INSTANCE;
    public static final DumbTorpedo DUMB_TORPEDO = DumbTorpedo.INSTANCE;
    public static final PosMissile POS_MISSILE = PosMissile.INSTANCE;
    public static final TrackMissile TRACK_MISSILE = TrackMissile.INSTANCE;
    public static final Torpedo TORPEDO = Torpedo.INSTANCE;
    public static final AntiRadarMissile ANTI_RADAR_MISSILE = AntiRadarMissile.INSTANCE;

    public WeaponType(String id, JsonPresetType.JsonPresetStatsFactory<? extends JsonPresetStats> statsFactory) {
        super(id, statsFactory);
    }

    public abstract EntityType<?> getDefaultEntityType();

    public static class None
    extends WeaponType {
        public static final String ID = "none";
        public static final None INSTANCE = new None();

        public None() {
            super(ID, (JsonPresetType.JsonPresetStatsFactory<? extends JsonPresetStats>)((JsonPresetType.JsonPresetStatsFactory)(key, data) -> NoWeaponStats.get()));
        }

        @Override
        public EntityType<?> getDefaultEntityType() {
            return (EntityType)ModEntities.BULLET.get();
        }
    }

    public static class Bullet
    extends WeaponType {
        public static final String ID = "bullet";
        public static final Bullet INSTANCE = new Bullet();

        public Bullet() {
            super(ID, (JsonPresetType.JsonPresetStatsFactory<? extends JsonPresetStats>)((JsonPresetType.JsonPresetStatsFactory)(key, data) -> new BulletStats(key, data)));
        }

        @Override
        public EntityType<?> getDefaultEntityType() {
            return (EntityType)ModEntities.BULLET.get();
        }
    }

    public static class Bomb
    extends WeaponType {
        public static final String ID = "bomb";
        public static final Bomb INSTANCE = new Bomb();

        public Bomb() {
            super(ID, (JsonPresetType.JsonPresetStatsFactory<? extends JsonPresetStats>)((JsonPresetType.JsonPresetStatsFactory)(key, data) -> new BombStats(key, data)));
        }

        @Override
        public EntityType<?> getDefaultEntityType() {
            return (EntityType)ModEntities.BOMB.get();
        }
    }

    public static class BunkerBuster
    extends WeaponType {
        public static final String ID = "bunker_buster";
        public static final BunkerBuster INSTANCE = new BunkerBuster();

        public BunkerBuster() {
            super(ID, (JsonPresetType.JsonPresetStatsFactory<? extends JsonPresetStats>)((JsonPresetType.JsonPresetStatsFactory)(key, data) -> new BunkerBusterStats(key, data)));
        }

        @Override
        public EntityType<?> getDefaultEntityType() {
            return (EntityType)ModEntities.BUNKER_BUSTER.get();
        }
    }

    public static class IrMissile
    extends WeaponType {
        public static final String ID = "ir_missile";
        public static final IrMissile INSTANCE = new IrMissile();

        public IrMissile() {
            super(ID, (JsonPresetType.JsonPresetStatsFactory<? extends JsonPresetStats>)((JsonPresetType.JsonPresetStatsFactory)(key, data) -> new IRMissileStats(key, data)));
        }

        @Override
        public EntityType<?> getDefaultEntityType() {
            return (EntityType)ModEntities.IR_MISSILE.get();
        }
    }

    public static class DumbTorpedo
    extends WeaponType {
        public static final String ID = "dumb_torpedo";
        public static final DumbTorpedo INSTANCE = new DumbTorpedo();

        public DumbTorpedo() {
            super(ID, (JsonPresetType.JsonPresetStatsFactory<? extends JsonPresetStats>)((JsonPresetType.JsonPresetStatsFactory)(key, data) -> new DumbTorpedoStats(key, data)));
        }

        @Override
        public EntityType<?> getDefaultEntityType() {
            return (EntityType)ModEntities.DUMB_TORPEDO_MISSILE.get();
        }
    }

    public static class PosMissile
    extends WeaponType {
        public static final String ID = "pos_missile";
        public static final PosMissile INSTANCE = new PosMissile();

        public PosMissile() {
            super(ID, (JsonPresetType.JsonPresetStatsFactory<? extends JsonPresetStats>)((JsonPresetType.JsonPresetStatsFactory)(key, data) -> new PosMissileStats(key, data)));
        }

        @Override
        public EntityType<?> getDefaultEntityType() {
            return (EntityType)ModEntities.POS_MISSILE.get();
        }
    }

    public static class TrackMissile
    extends WeaponType {
        public static final String ID = "track_missile";
        public static final TrackMissile INSTANCE = new TrackMissile();

        public TrackMissile() {
            super(ID, (JsonPresetType.JsonPresetStatsFactory<? extends JsonPresetStats>)((JsonPresetType.JsonPresetStatsFactory)(key, data) -> new TrackMissileStats(key, data)));
        }

        @Override
        public EntityType<?> getDefaultEntityType() {
            return (EntityType)ModEntities.TRACK_MISSILE.get();
        }
    }

    public static class Torpedo
    extends WeaponType {
        public static final String ID = "torpedo";
        public static final Torpedo INSTANCE = new Torpedo();

        public Torpedo() {
            super(ID, (JsonPresetType.JsonPresetStatsFactory<? extends JsonPresetStats>)((JsonPresetType.JsonPresetStatsFactory)(key, data) -> new TorpedoStats(key, data)));
        }

        @Override
        public EntityType<?> getDefaultEntityType() {
            return (EntityType)ModEntities.TORPEDO_MISSILE.get();
        }
    }

    public static class AntiRadarMissile
    extends WeaponType {
        public static final String ID = "anti_radar_missile";
        public static final AntiRadarMissile INSTANCE = new AntiRadarMissile();

        public AntiRadarMissile() {
            super(ID, (JsonPresetType.JsonPresetStatsFactory<? extends JsonPresetStats>)((JsonPresetType.JsonPresetStatsFactory)(key, data) -> new AntiRadarMissileStats(key, data)));
        }

        @Override
        public EntityType<?> getDefaultEntityType() {
            return (EntityType)ModEntities.ANTI_RADAR_MISSILE.get();
        }
    }
}

