/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.weapon.instance;

import com.mojang.math.Quaternion;
import com.onewhohears.dscombat.common.network.PacketHandler;
import com.onewhohears.dscombat.common.network.toclient.ToClientOnShoot;
import com.onewhohears.dscombat.common.network.toclient.ToClientWeaponAmmo;
import com.onewhohears.dscombat.data.weapon.WeaponShootParameters;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.parts.EntityPart;
import com.onewhohears.dscombat.entity.parts.EntityTurret;
import com.onewhohears.dscombat.entity.parts.EntityWeaponRack;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.weapon.EntityWeapon;
import com.onewhohears.dscombat.util.UtilSound;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetInstance;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.UtilParse;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public abstract class WeaponInstance<T extends WeaponStats>
extends JsonPresetInstance<T> {
    private int currentAmmo;
    private int recoilTime;
    private int maxAmmo;
    private Vec3 pos = Vec3.f_82478_;
    private String failedLaunchReason;
    private String slotId = "";
    private boolean overrideGroundCheck = false;
    protected float changeLaunchPitch = 0.0f;
    @Nullable
    protected EntityWeapon<?> firedWeapon;

    public WeaponInstance(T stats) {
        super(stats);
    }

    public void readNBT(CompoundTag tag) {
        super.readNBT(tag);
        this.currentAmmo = tag.m_128451_("currentAmmo");
        this.maxAmmo = tag.m_128451_("maxAmmo");
        this.slotId = tag.m_128461_("slotId");
        this.pos = UtilParse.readVec3((CompoundTag)tag, (String)"pos");
    }

    public CompoundTag writeNBT() {
        CompoundTag tag = super.writeNBT();
        tag.m_128359_("weaponId", this.getStatsId());
        tag.m_128405_("currentAmmo", this.getCurrentAmmo());
        tag.m_128405_("maxAmmo", this.getMaxAmmo());
        UtilParse.writeVec3((CompoundTag)tag, (Vec3)this.pos, (String)"pos");
        tag.m_128359_("slotId", this.slotId);
        return tag;
    }

    @Nullable
    public EntityWeapon<?> getEntity(Level level) {
        EntityType<?> type = ((WeaponStats)this.getStats()).getEntityType();
        Entity entity = type.m_20615_(level);
        if (entity instanceof EntityWeapon) {
            EntityWeapon w = (EntityWeapon)entity;
            w.setPreset(this.getStatsId());
            return w;
        }
        return null;
    }

    public EntityWeapon<?> getShootEntity(WeaponShootParameters params) {
        if (((WeaponStats)this.getStats()).isNoWeapon()) {
            this.setLaunchFail(null);
            return null;
        }
        if (!params.ignoreRecoil && !this.checkRecoil()) {
            this.setLaunchFail(null);
            return null;
        }
        if (!this.checkAmmo(1, params.owner)) {
            this.setLaunchFail("error.dscombat.no_ammo");
            return null;
        }
        if (params.vehicle != null && !this.overrideGroundCheck && !((WeaponStats)this.getStats()).canShootOnGround() && params.vehicle.m_20096_()) {
            this.setLaunchFail("error.dscombat.cant_shoot_on_ground");
            return null;
        }
        EntityWeapon<?> w = this.getEntity(params.level);
        if (w == null) {
            return null;
        }
        w.m_5602_(params.owner);
        w.m_146884_(params.pos);
        this.setDirection(w, params.direction);
        return w;
    }

    public void setDirection(EntityWeapon<?> weapon, Vec3 direction) {
        float pitch = UtilAngles.getPitch((Vec3)direction);
        float yaw = UtilAngles.getYaw((Vec3)direction);
        weapon.m_146926_(pitch - this.changeLaunchPitch);
        weapon.m_146922_(yaw);
    }

    public boolean shootFromVehicle(Level level, Entity owner, Vec3 direction, EntityVehicle vehicle, boolean consume) {
        this.overrideGroundCheck = false;
        EntityWeapon<?> w = this.getShootEntity(new WeaponShootParameters(level, owner, vehicle.m_20182_().m_82549_(UtilAngles.rotateVector((Vec3)this.getLaunchPos(), (Quaternion)vehicle.getQ())), direction, vehicle, false, false));
        if (w == null) {
            return false;
        }
        level.m_7967_(w);
        this.playShootSound(level, w.m_20182_());
        this.setLaunchSuccess(1, owner, consume);
        this.updateClientAmmo(vehicle);
        vehicle.lastShootTime = vehicle.f_19797_;
        EntityPart entityPart = vehicle.getPartBySlotId(this.getSlotId());
        if (entityPart instanceof EntityWeaponRack) {
            EntityWeaponRack rack = (EntityWeaponRack)entityPart;
            rack.lastShootTime = rack.f_19797_;
            ToClientOnShoot.onShootWeaponRack(rack, owner);
        }
        this.firedWeapon = w;
        return true;
    }

    public boolean shootFromTurret(Level level, Entity owner, Vec3 direction, Vec3 pos, @Nullable EntityVehicle vehicle, boolean consume) {
        return this.shootFromTurret(level, owner, direction, pos, vehicle, consume, false);
    }

    public boolean shootFromTurret(Level level, Entity owner, Vec3 direction, Vec3 pos, @Nullable EntityVehicle vehicle, boolean consume, boolean ignoreRecoil) {
        this.overrideGroundCheck = true;
        EntityWeapon<?> w = this.getShootEntity(new WeaponShootParameters(level, owner, pos, direction, vehicle, ignoreRecoil, true));
        if (w == null) {
            return false;
        }
        level.m_7967_(w);
        this.playShootSound(level, w.m_20182_());
        this.setLaunchSuccess(1, owner, consume);
        if (vehicle != null && !ignoreRecoil) {
            vehicle.lastShootTime = vehicle.f_19797_;
            EntityPart entityPart = vehicle.getPartBySlotId(this.getSlotId());
            if (entityPart instanceof EntityTurret) {
                EntityTurret turret = (EntityTurret)entityPart;
                turret.setLastShootTick(turret.f_19797_);
                ToClientOnShoot.onShootTurret(turret, owner);
            }
        }
        this.firedWeapon = w;
        return true;
    }

    @Nullable
    public EntityWeapon<?> getFiredWeapon() {
        return this.firedWeapon;
    }

    public void playShootSound(Level level, Vec3 pos) {
        UtilSound.sendDelayedSound(((WeaponStats)this.getStats()).getShootSound(), pos, 160.0f, (ResourceKey<Level>)level.m_46472_(), 1.0f, 1.0f);
    }

    public void updateClientAmmo(EntityVehicle vehicle) {
        if (vehicle == null) {
            return;
        }
        if (vehicle.f_19853_.f_46443_) {
            return;
        }
        PacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> vehicle), (Object)new ToClientWeaponAmmo(vehicle.m_19879_(), this.getStatsId(), this.slotId, this.getCurrentAmmo()));
    }

    public void tick(@Nullable EntityVehicle parent, boolean isSelected) {
        if (this.recoilTime > 1) {
            --this.recoilTime;
        }
    }

    public boolean checkAmmo(int ammoNum, Entity shooter) {
        ServerPlayer p;
        if (shooter instanceof ServerPlayer && (p = (ServerPlayer)shooter).m_7500_()) {
            return true;
        }
        return this.getCurrentAmmo() >= ammoNum;
    }

    public boolean checkRecoil() {
        return this.recoilTime <= 1;
    }

    public Vec3 getLaunchPos() {
        return this.pos;
    }

    public void setLaunchPos(Vec3 pos) {
        this.pos = pos;
    }

    public int getMaxAmmo() {
        return this.maxAmmo;
    }

    public void setMaxAmmo(int max) {
        this.maxAmmo = max;
    }

    public int getCurrentAmmo() {
        return this.currentAmmo;
    }

    public void forceSetCurrentAmmo(int currentAmmo) {
        this.currentAmmo = currentAmmo;
    }

    public void setCurrentAmmo(int currentAmmo) {
        if (currentAmmo < 0) {
            currentAmmo = 0;
        }
        if (currentAmmo > this.getMaxAmmo()) {
            currentAmmo = this.getMaxAmmo();
        }
        this.currentAmmo = currentAmmo;
    }

    public int addAmmo(int num) {
        int total = this.getCurrentAmmo() + num;
        int r = 0;
        if (total > this.getMaxAmmo()) {
            r = total - this.getMaxAmmo();
            total = this.getMaxAmmo();
        } else if (total < 0) {
            r = total;
            total = 0;
        }
        this.setCurrentAmmo(total);
        return r;
    }

    public void setChangeLaunchPitch(float degrees) {
        this.changeLaunchPitch = degrees;
    }

    public boolean isFailedLaunch() {
        return this.failedLaunchReason != null;
    }

    @Nullable
    public String getFailedLaunchReason() {
        return this.failedLaunchReason;
    }

    public void setLaunchSuccess(int ammoNum, Entity shooter, boolean consume) {
        this.failedLaunchReason = null;
        if (consume) {
            this.addAmmo(-ammoNum);
        }
        this.recoilTime = ((WeaponStats)this.getStats()).getFireRate();
    }

    public void setLaunchFail(String failedLaunchReason) {
        this.failedLaunchReason = failedLaunchReason;
    }

    public String getSlotId() {
        return this.slotId;
    }

    public boolean isInternal() {
        return this.slotId == "";
    }

    public void setSlot(String slotId) {
        this.slotId = slotId;
    }

    public void setInternal() {
        this.slotId = "";
    }

    public boolean idMatch(String id, String slotId) {
        if (slotId == null) {
            return false;
        }
        if (id == null) {
            return false;
        }
        return this.getStatsId().equals(id) && this.getSlotId().equals(slotId);
    }

    public boolean couldRadarWeaponTargetEntity(Entity entity, Entity radar) {
        return entity.m_6084_() && !entity.m_5833_() && !radar.m_7307_(entity) && (double)radar.m_20270_(entity) <= ((WeaponStats)this.getStats()).getMobTurretRange();
    }

    @Nullable
    public Vec3 estimateImpactPosition(EntityVehicle vehicle) {
        if (!((WeaponStats)this.getStats()).isAimAssist()) {
            return null;
        }
        Vec3 startPos = vehicle.m_20182_().m_82549_(UtilAngles.rotateVector((Vec3)this.getLaunchPos(), (Quaternion)vehicle.getQBySide()));
        Vec3 startMove = this.getStartMove(vehicle);
        Vec3 acc = this.getAcc(vehicle);
        double distSqr = 0.0;
        Vec3 pos = startPos;
        Vec3 move = startMove;
        while (distSqr <= 40000.0) {
            distSqr += move.m_82556_();
            Vec3 prevPos = pos;
            pos = pos.m_82549_(move);
            if (pos.f_82480_ < -64.0) {
                pos = new Vec3(pos.f_82479_, -64.0, pos.f_82481_);
            }
            move = move.m_82549_(acc);
            Vec3 raycast = UtilEntity.raycastBlock((Level)vehicle.f_19853_, (Vec3)prevPos, (Vec3)pos);
            if (raycast == null) continue;
            return raycast;
        }
        return pos;
    }

    protected Vec3 getStartMove(EntityVehicle vehicle) {
        return vehicle.m_20184_();
    }

    protected Vec3 getAcc(EntityVehicle vehicle) {
        return new Vec3(0.0, -0.024525, 0.0);
    }
}

