/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.data.weapon.stats;

import com.google.gson.JsonObject;
import com.onewhohears.dscombat.data.vehicle.physics.DSCPhyCons;
import com.onewhohears.dscombat.data.weapon.AbstractWeaponBuilders;
import com.onewhohears.dscombat.data.weapon.WeaponType;
import com.onewhohears.dscombat.data.weapon.instance.BulletInstance;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetInstance;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetType;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.UtilParse;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class BulletStats
extends WeaponStats {
    private final float damage;
    private final double speed;
    private final boolean explosive;
    private final boolean destroyTerrain;
    private final boolean causesFire;
    private final float explosionRadius;
    private final float inaccuracy;
    private final int explodeNum;
    private final boolean useSpeedScale;

    public BulletStats(ResourceLocation key, JsonObject json) {
        super(key, json);
        this.damage = UtilParse.getFloatSafe((JsonObject)json, (String)"damage", (float)0.0f);
        this.speed = UtilParse.getFloatSafe((JsonObject)json, (String)"speed", (float)0.0f);
        this.explosive = UtilParse.getBooleanSafe((JsonObject)json, (String)"explosive", (boolean)false);
        this.destroyTerrain = UtilParse.getBooleanSafe((JsonObject)json, (String)"destroyTerrain", (boolean)false);
        this.causesFire = UtilParse.getBooleanSafe((JsonObject)json, (String)"causesFire", (boolean)false);
        this.explosionRadius = UtilParse.getFloatSafe((JsonObject)json, (String)"explosionRadius", (float)0.0f);
        this.inaccuracy = UtilParse.getFloatSafe((JsonObject)json, (String)"inaccuracy", (float)0.0f);
        this.explodeNum = UtilParse.getIntSafe((JsonObject)json, (String)"explodeNum", (int)1);
        this.useSpeedScale = UtilParse.getBooleanSafe((JsonObject)json, (String)"useSpeedScale", (boolean)false);
    }

    public float getDamage() {
        return this.damage;
    }

    public double getUnscaledSpeed() {
        return this.speed;
    }

    public boolean isExplosive() {
        return this.explosive;
    }

    public boolean isDestroyTerrain() {
        return this.destroyTerrain;
    }

    public float getExplosionRadius() {
        return this.explosionRadius;
    }

    public boolean isCausesFire() {
        return this.causesFire;
    }

    public float getInaccuracy() {
        return this.inaccuracy;
    }

    public int getExplodeNum() {
        return this.explodeNum;
    }

    public boolean isUseSpeedScale() {
        return this.useSpeedScale;
    }

    public double getSpeed() {
        if (this.isUseSpeedScale()) {
            return DSCPhyCons.getIRLScale() * this.getUnscaledSpeed();
        }
        return this.getUnscaledSpeed();
    }

    @Override
    public double getMobTurretRange() {
        return Math.min(300.0, this.getSpeed() * (double)this.getMaxAge());
    }

    @Override
    public void addToolTips(List<Component> tips, boolean advanced) {
        super.addToolTips(tips, advanced);
        tips.add((Component)UtilMCText.translatable((String)"info.dscombat.damage").m_130946_(": " + this.getDamage()).m_6270_(Style.f_131099_.m_178520_(6266528)));
        if (advanced) {
            tips.add((Component)UtilMCText.translatable((String)"info.dscombat.max_speed").m_130946_(": " + this.getSpeed()).m_6270_(Style.f_131099_.m_178520_(6266528)));
        }
        if (this.isExplosive()) {
            tips.add((Component)UtilMCText.translatable((String)"info.dscombat.explosion_radius").m_130946_(": " + this.getExplosionRadius()).m_6270_(Style.f_131099_.m_178520_(0xAA0000)));
            if (advanced) {
                tips.add((Component)UtilMCText.translatable((String)"info.dscombat.number_of_explosions").m_130946_(": " + this.getExplodeNum()).m_6270_(Style.f_131099_.m_178520_(0xAA0000)));
            }
        }
        if (advanced) {
            tips.add((Component)UtilMCText.translatable((String)"info.dscombat.inaccuracy").m_130946_(": " + this.getInaccuracy()).m_6270_(Style.f_131099_.m_178520_(6266528)));
        }
        if (this.isCausesFire()) {
            tips.add((Component)UtilMCText.translatable((String)"info.dscombat.incendiary").m_6270_(Style.f_131099_.m_178520_(0xAA0000)));
        }
    }

    @Override
    public String getWeaponTypeCode() {
        return UtilMCText.transString((String)"weapon_code.dscombat.gun");
    }

    @Override
    public String getDefaultIconLocation() {
        if (this.isExplosive()) {
            return "dscombat:textures/ui/weapon_icons/he_bullet.png";
        }
        return "dscombat:textures/ui/weapon_icons/bullet.png";
    }

    public JsonPresetInstance<?> createPresetInstance() {
        return new BulletInstance<BulletStats>(this);
    }

    @Override
    public boolean isBullet() {
        return true;
    }

    @Override
    public boolean isAimAssist() {
        return true;
    }

    public JsonPresetType getType() {
        return WeaponType.BULLET;
    }

    public static class Builder
    extends AbstractWeaponBuilders.BulletBuilder<Builder> {
        protected Builder(String namespace, String name) {
            super(namespace, name, WeaponType.BULLET);
        }

        public static Builder bulletBuilder(String namespace, String name) {
            return new Builder(namespace, name);
        }
    }
}

