/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.parts;

import com.mojang.math.Quaternion;
import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.command.DSCGameRules;
import com.onewhohears.dscombat.data.parts.PartType;
import com.onewhohears.dscombat.data.parts.instance.TurretInstance;
import com.onewhohears.dscombat.data.parts.stats.TurretStats;
import com.onewhohears.dscombat.data.weapon.instance.WeaponInstance;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.ai.goal.TurretShootGoal;
import com.onewhohears.dscombat.entity.ai.goal.TurretTargetGoal;
import com.onewhohears.dscombat.entity.parts.EntityRidablePart;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.weapon.EntityWeapon;
import com.onewhohears.dscombat.init.ModTags;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityTurret
extends EntityRidablePart<TurretStats, TurretInstance<TurretStats>> {
    public static final EntityDataAccessor<Float> RELROTX = SynchedEntityData.m_135353_(EntityTurret.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> RELROTY = SynchedEntityData.m_135353_(EntityTurret.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public float xRotRelO;
    public float yRotRelO;
    private int newRiderCoolDown;
    private int overrideAnglesTime = -100;
    private float overrideRotX;
    private float overrideRotY;
    protected int lastShootTick;
    protected Goal shootGoal;
    protected Goal targetGoal;

    public EntityTurret(EntityType<?> type, Level level, String defaultPreset) {
        super(type, level, defaultPreset);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RELROTX, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(RELROTY, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.m_146926_(tag.m_128457_("xRot"));
        this.m_146922_(tag.m_128457_("yRot"));
        this.setRelRotX(tag.m_128457_("relrotx"));
        this.setRelRotY(tag.m_128457_("relroty"));
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("xRot", this.m_146909_());
        tag.m_128350_("yRot", this.m_146908_());
        tag.m_128350_("relrotx", this.getRelRotX());
        tag.m_128350_("relroty", this.getRelRotY());
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.tickRotate();
    }

    public void setOverrideLookAngles(float overrideRotX, float overrideRotY) {
        this.overrideAnglesTime = this.f_19797_;
        this.overrideRotX = overrideRotX;
        this.overrideRotY = overrideRotY;
    }

    protected void tickRotate() {
        float goalRotY;
        float goalRotX;
        this.xRotRelO = this.getRelRotX();
        this.yRotRelO = this.getRelRotY();
        LivingEntity gunner = this.getPassenger();
        if (this.f_19797_ - this.overrideAnglesTime < 100) {
            goalRotX = this.overrideRotX;
            goalRotY = this.overrideRotY;
        } else if (gunner != null) {
            goalRotX = gunner.m_146909_();
            goalRotY = gunner.m_6080_();
        } else {
            return;
        }
        this.rotateTowards(goalRotX, goalRotY);
    }

    protected void rotateTowards(float goalRotX, float goalRotY) {
        Quaternion ra = Quaternion.f_80118_;
        EntityVehicle vehicle = this.getParentVehicle();
        if (vehicle != null) {
            ra = vehicle.getQBySide();
        }
        if (!this.m_9236_().m_5776_()) {
            if (this.newRiderCoolDown > 0) {
                --this.newRiderCoolDown;
            }
            float rely = this.yRotRelO;
            float relx = this.xRotRelO;
            float rotrate = this.getRotRate();
            float minrotx = this.getMinRotX();
            float maxrotx = this.getMaxRotX();
            WeaponInstance<?> data = this.getWeaponData();
            if (data != null) {
                data.tick(vehicle, true);
            }
            float[] relangles = UtilAngles.globalToRelativeDegrees((float)goalRotX, (float)goalRotY, (Quaternion)ra);
            float rg1 = relangles[1] + 360.0f;
            float rg2 = relangles[1] - 360.0f;
            float d1 = Math.abs(rg1 - rely);
            float d2 = Math.abs(rg2 - rely);
            float d3 = Math.abs(relangles[1] - rely);
            if (d1 < d2 && d1 < d3) {
                relangles[1] = relangles[1] + 360.0f;
            } else if (d2 < d1 && d2 < d3) {
                relangles[1] = relangles[1] - 360.0f;
            }
            if (relangles[0] > maxrotx) {
                relangles[0] = maxrotx;
            } else if (relangles[0] < minrotx) {
                relangles[0] = minrotx;
            }
            float rotdiffx = relangles[0] - relx;
            float rotdiffy = relangles[1] - rely;
            float dx = Math.abs(rotdiffx) < rotrate ? rotdiffx : rotrate * Math.signum(rotdiffx);
            float dy = Math.abs(rotdiffy) < rotrate ? rotdiffy : rotrate * Math.signum(rotdiffy);
            this.setRelRotX(Mth.m_14177_((float)(relx + dx)));
            this.setRelRotY(Mth.m_14177_((float)(rely + dy)));
        }
        float[] global = UtilAngles.relativeToGlobalDegrees((float)this.getRelRotX(), (float)this.getRelRotY(), (Quaternion)ra);
        this.m_146926_(global[0]);
        this.m_146922_(global[1]);
    }

    @Override
    protected Vec3 getPassengerRelPos(Entity passenger, EntityVehicle craft) {
        Quaternion q = this.f_19853_.f_46443_ ? craft.getClientQ() : craft.getQ();
        double offset = this.m_6048_() + passenger.m_6049_() + (double)passenger.m_20192_();
        float cos = Mth.m_14089_((float)(this.getRelRotY() * ((float)Math.PI / 180)));
        float sin = Mth.m_14031_((float)(this.getRelRotY() * ((float)Math.PI / 180)));
        return UtilAngles.rotateVector((Vec3)new Vec3(this.getPassengerOffsets().f_82479_ * (double)cos + this.getPassengerOffsets().f_82481_ * (double)sin, offset, this.getPassengerOffsets().f_82481_ * (double)cos + this.getPassengerOffsets().f_82479_ * (double)sin), (Quaternion)q).m_82492_(0.0, (double)passenger.m_20192_(), 0.0);
    }

    protected void addTurretAI(Mob mob) {
        this.shootGoal = this.makeShootGoal(mob);
        mob.f_21345_.m_25352_(0, this.shootGoal);
        if (mob.m_6095_().m_204039_(ModTags.EntityTypes.TURRET_TARGET_PLAYERS)) {
            this.targetGoal = this.makeTargetPlayerGoal(mob);
            mob.f_21346_.m_25352_(0, this.targetGoal);
        } else if (mob.m_6095_().m_204039_(ModTags.EntityTypes.TURRET_TARGET_MONSTERS)) {
            this.targetGoal = this.makeTargetEnemyGoal(mob);
            mob.f_21346_.m_25352_(0, this.targetGoal);
        }
    }

    protected void removeTurretAI(Mob mob) {
        if (this.shootGoal != null) {
            mob.f_21345_.m_25363_(this.shootGoal);
            this.shootGoal = null;
        }
        if (this.targetGoal != null) {
            mob.f_21346_.m_25363_(this.targetGoal);
            this.targetGoal = null;
        }
    }

    protected Goal makeShootGoal(Mob mob) {
        return new TurretShootGoal(mob, this);
    }

    protected Goal makeTargetPlayerGoal(Mob mob) {
        return TurretTargetGoal.targetPlayers(mob, this);
    }

    protected Goal makeTargetEnemyGoal(Mob mob) {
        return TurretTargetGoal.targetEnemy(mob, this);
    }

    @Override
    public boolean hasAIUsingTurret() {
        return this.targetGoal != null;
    }

    public boolean isBotUsingRadar() {
        if (!this.hasAIUsingTurret()) {
            return false;
        }
        WeaponInstance<?> wd = this.getWeaponData();
        if (wd == null) {
            return false;
        }
        return ((WeaponStats)wd.getStats()).requiresRadar();
    }

    public double getAIHorizontalRange() {
        WeaponInstance<?> wd = this.getWeaponData();
        if (wd == null) {
            return 300.0;
        }
        return ((WeaponStats)wd.getStats()).getMobTurretRange();
    }

    public double getAIVerticalRange() {
        return this.f_19853_.m_46469_().m_46215_(DSCGameRules.MOB_TURRET_VERTICAL_RANGE);
    }

    @Override
    protected void m_20348_(Entity passenger) {
        super.m_20348_(passenger);
        this.newRiderCoolDown = 10;
        if (passenger instanceof Mob) {
            Mob m = (Mob)passenger;
            this.addTurretAI(m);
        }
    }

    @Override
    protected void m_20351_(Entity passenger) {
        super.m_20351_(passenger);
        if (passenger instanceof Mob) {
            Mob m = (Mob)passenger;
            this.removeTurretAI(m);
        }
    }

    @Override
    public boolean shouldRender() {
        return true;
    }

    @Override
    protected double getClientRenderDistance() {
        return (Double)Config.CLIENT.renderTurretDistance.get();
    }

    public int getAmmo() {
        if (this.getPartInstance() == null) {
            return 0;
        }
        return (int)((TurretInstance)this.getPartInstance()).getCurrentAmmo();
    }

    public int getMaxAmmo() {
        if (this.getPartInstance() == null) {
            return 0;
        }
        return (int)((TurretInstance)this.getPartInstance()).getMaxAmmo();
    }

    public int addAmmo(int ammo) {
        if (this.getPartInstance() == null) {
            return 0;
        }
        return ((TurretInstance)this.getPartInstance()).addWeaponAmmo(ammo);
    }

    public String getWeaponId() {
        if (this.getPartInstance() == null) {
            return "";
        }
        return ((TurretInstance)this.getPartInstance()).getWeaponId();
    }

    @Nullable
    public WeaponInstance<?> getWeaponData() {
        TurretInstance instance = (TurretInstance)this.getPartInstance();
        if (instance == null) {
            return null;
        }
        return instance.getWeaponData();
    }

    public void shoot(Entity shooter) {
        WeaponInstance<?> data = this.getWeaponData();
        if (this.m_9236_().m_5776_() || data == null || this.newRiderCoolDown > 0) {
            return;
        }
        boolean consume = true;
        Vec3 pos = this.m_20182_();
        EntityVehicle parent = null;
        Entity entity = this.m_20202_();
        if (entity instanceof EntityVehicle) {
            EntityVehicle craft = (EntityVehicle)entity;
            if (!craft.isOperational()) {
                return;
            }
            pos = pos.m_82549_(UtilAngles.rotateVector((Vec3)new Vec3(0.0, ((TurretStats)this.getStats()).getWeaponOffset(), 0.0), (Quaternion)craft.getQ()));
            if (craft.isNoConsume()) {
                consume = false;
            }
            parent = craft;
        }
        ServerPlayer p = null;
        if (shooter instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)shooter;
            if (player.m_7500_()) {
                consume = false;
            }
            p = player;
        }
        boolean consumeAmmo = this.m_9236_().m_46469_().m_46207_(DSCGameRules.CONSUME_AMMO);
        boolean couldShoot = data.checkRecoil();
        data.setSlot(this.getSlotId());
        data.shootFromTurret(this.m_9236_(), shooter, this.m_20154_(), pos, parent, consume && consumeAmmo);
        if (couldShoot) {
            this.specialShoot(shooter, pos, parent, consume && consumeAmmo, data);
        }
        if (data.isFailedLaunch()) {
            if (p != null) {
                p.m_5661_((Component)UtilMCText.translatable((String)data.getFailedLaunchReason()), true);
            }
        } else {
            this.setLastShootTick(this.f_19797_);
            TurretInstance instance = (TurretInstance)this.getPartInstance();
            if (instance != null) {
                instance.setCurrentAmmo(data.getCurrentAmmo());
            }
        }
    }

    @Nullable
    public EntityWeapon<?> getFiredWeapon() {
        WeaponInstance<?> data = this.getWeaponData();
        if (data == null) {
            return null;
        }
        return data.getFiredWeapon();
    }

    protected void specialShoot(Entity shooter, Vec3 pos, EntityVehicle parent, boolean consume, WeaponInstance<?> data) {
        if (this.getShootType() == ShootType.NORMAL) {
            return;
        }
        if (this.getShootType() == ShootType.MARK7) {
            float d = 1.0f;
            float yRad = this.m_146908_() * ((float)Math.PI / 180);
            Vec3 posL = pos.m_82549_(new Vec3((double)(-d * Mth.m_14089_((float)yRad)), 0.0, (double)(-d * (float)Mth.m_14205_((double)yRad))));
            Vec3 posR = pos.m_82549_(new Vec3((double)(d * Mth.m_14089_((float)yRad)), 0.0, (double)(d * (float)Mth.m_14205_((double)yRad))));
            data.shootFromTurret(this.m_9236_(), shooter, this.m_20154_(), posL, parent, consume, true);
            data.shootFromTurret(this.m_9236_(), shooter, this.m_20154_(), posR, parent, consume, true);
        }
    }

    public ShootType getShootType() {
        return ((TurretStats)this.getStats()).getShootType();
    }

    public int getLastShootTick() {
        return this.lastShootTick;
    }

    public void setLastShootTick(int tick) {
        this.lastShootTick = tick;
    }

    @Override
    public PartType getPartType() {
        return PartType.TURRENT;
    }

    public TurretStats.RotBounds getRotBounds() {
        return ((TurretStats)this.getStats()).getRotBounds();
    }

    public float getMinRotX() {
        return this.getRotBounds().minRotX;
    }

    public float getMaxRotX() {
        return this.getRotBounds().maxRotX;
    }

    public float getRotRate() {
        return this.getRotBounds().rotRate;
    }

    public float getRelRotX() {
        return ((Float)this.f_19804_.m_135370_(RELROTX)).floatValue();
    }

    public float getRelRotY() {
        return ((Float)this.f_19804_.m_135370_(RELROTY)).floatValue();
    }

    public void setRelRotX(float degrees) {
        this.f_19804_.m_135381_(RELROTX, (Object)Float.valueOf(degrees));
    }

    public void setRelRotY(float degrees) {
        this.f_19804_.m_135381_(RELROTY, (Object)Float.valueOf(degrees));
    }

    @Override
    public boolean canGetHurt() {
        return true;
    }

    @Override
    public boolean isTurret() {
        return true;
    }

    @Override
    public boolean m_6097_() {
        return true;
    }

    @Override
    public boolean m_6084_() {
        return true;
    }

    public void onClientShoot() {
        this.setLastShootTick(this.f_19797_);
    }

    public static enum ShootType {
        NORMAL,
        MARK7;

    }
}

