/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.vehicle;

import com.mojang.math.Quaternion;
import com.onewhohears.dscombat.Config;
import com.onewhohears.dscombat.data.vehicle.VehicleType;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EntityBoat
extends EntityVehicle {
    protected double waterLevel;

    public EntityBoat(EntityType<? extends EntityBoat> entity, Level level, String defaultPreset) {
        super(entity, level, defaultPreset);
    }

    @Override
    public VehicleType getVehicleType() {
        return VehicleType.BOAT;
    }

    @Override
    public void applyGroundBreaks() {
    }

    @Override
    public void applyAirBreaks() {
        this.throttleToZero();
        super.applyAirBreaks();
    }

    @Override
    public boolean canGroundBrake() {
        return this.m_20069_() && ((VehicleStats)this.getStats()).break_deacc_air > 0.0f && this.isOperational();
    }

    @Override
    public boolean canAirBrake() {
        return false;
    }

    public boolean canWaterBrake() {
        return this.m_20069_() && ((VehicleStats)this.getStats()).break_deacc_air > 0.0f && this.isOperational();
    }

    @Override
    public double getDriveAcc() {
        return 0.0;
    }

    @Override
    public void calcWaterMovement(Quaternion q) {
        super.calcWaterMovement(q);
        if (!this.checkInWater()) {
            return;
        }
        this.flatten(q, 2.0f, 2.0f, true);
        this.tickFloat();
        if (this.canWaterBrake() && this.isAirBreaking()) {
            this.applyAirBreaks();
        }
    }

    protected void tickFloat() {
        Vec3 weightF = this.getWeightForce();
        float F = this.m_20205_() * this.m_20205_() * 8000.0f;
        float maxF = F * this.m_20206_();
        if ((double)maxF < Math.abs(weightF.f_82480_)) {
            this.forces = this.forces.m_82520_(0.0, (double)maxF, 0.0);
            return;
        }
        if (!this.couldFloat()) {
            this.forces = this.forces.m_82549_(weightF.m_82490_(-0.9));
            return;
        }
        double bbMin = this.m_20191_().f_82289_;
        double actualF = (double)F * (this.waterLevel - bbMin);
        Vec3 floatF = new Vec3(0.0, actualF, 0.0);
        this.forces = this.forces.m_82549_(floatF);
        Vec3 move = this.m_20184_();
        double stableDisplacement = Math.abs(weightF.f_82480_) / (double)F;
        double stableY = this.waterLevel - stableDisplacement;
        double stableDiff = stableY - bbMin;
        if (Math.abs(move.f_82480_) < 0.1 && Math.abs(stableDiff) < 0.1) {
            double posBBDiff = this.m_20186_() - bbMin;
            this.m_6034_(this.m_20182_().f_82479_, stableY + posBBDiff, this.m_20182_().f_82481_);
            move = move.m_82542_(1.0, 0.0, 1.0);
            this.forces = this.forces.m_82542_(1.0, 0.0, 1.0);
        } else if (stableDiff > 0.0 && move.f_82480_ == 0.0) {
            this.m_146884_(this.m_20182_().m_82520_(0.0, this.forces.f_82480_ / (double)this.getTotalMass(), 0.0));
        } else {
            move = move.m_82542_(1.0, 0.9, 1.0);
        }
        this.m_20256_(move);
    }

    public double getFloatSpeed() {
        return 0.02;
    }

    @Override
    public boolean isGroundBraking() {
        return this.inputs.special;
    }

    public boolean couldFloat() {
        return this.isOperational();
    }

    protected boolean checkInWater() {
        AABB aabb = this.m_20191_();
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82289_);
        int l = Mth.m_14165_((double)aabb.f_82292_);
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        boolean flag = false;
        this.waterLevel = -1.7976931348623157E308;
        BlockPos.MutableBlockPos mbp = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    mbp.m_122178_(k1, l1, i2);
                    FluidState fluidstate = this.f_19853_.m_6425_((BlockPos)mbp);
                    if (!fluidstate.m_205070_(FluidTags.f_13131_)) continue;
                    float f = (float)l1 + fluidstate.m_76155_((BlockGetter)this.f_19853_, (BlockPos)mbp);
                    this.waterLevel = Math.max((double)f, this.waterLevel);
                    flag = aabb.f_82289_ < (double)f;
                }
            }
        }
        return flag;
    }

    @Override
    public double getMaxSpeedForMotion() {
        float th = this.getCurrentThrottle();
        double max = super.getMaxSpeedForMotion();
        if (th < 0.0f) {
            return max * 0.25;
        }
        return max;
    }

    @Override
    public double getMaxSpeedFactor() {
        return super.getMaxSpeedFactor() * (Double)Config.SERVER.boatSpeedFactor.get();
    }

    @Override
    public double getPushThrustMag() {
        return super.getPushThrustMag();
    }

    @Override
    public Vec3 getThrustForce(Quaternion q) {
        if (!this.m_20069_()) {
            return Vec3.f_82478_;
        }
        Vec3 direction = UtilAngles.getRollAxis((Quaternion)q);
        return direction.m_82490_(this.getPushThrustMag());
    }

    @Override
    public double getDragArea() {
        double area = super.getDragArea();
        if (this.m_20069_()) {
            double angle = UtilGeometry.angleBetweenDegrees((Vec3)this.m_20184_(), (Vec3)this.m_20154_());
            area = Math.max(area * 0.025, area * Math.sin(0.01745329238474369 * angle));
        }
        return area;
    }

    @Override
    public boolean isLandingGear() {
        return false;
    }

    @Override
    public float getStepHeight() {
        return 0.2f;
    }

    @Override
    public void waterDamage() {
        if (this.waterLevel > this.m_20191_().f_82292_) {
            super.waterDamage();
        }
    }

    @Override
    public boolean canOpenPartsMenu() {
        return (double)this.xzSpeed < 0.1 || this.isTestMode();
    }

    @Override
    public String getOpenMenuError() {
        return "error.dscombat.no_menu_moving";
    }

    @Override
    public boolean canToggleLandingGear() {
        return false;
    }

    @Override
    public boolean isPitchControllable() {
        return false;
    }

    @Override
    public boolean isRollControllable() {
        return false;
    }

    @Override
    public boolean canDriveOnGround() {
        return false;
    }

    @Override
    public boolean ignoreToItemFlyCheck() {
        return true;
    }
}

