/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.vehicle.wind_tunnel;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.math.Quaternion;
import com.onewhohears.dscombat.data.vehicle.VehiclePresets;
import com.onewhohears.dscombat.data.vehicle.physics.PhysicsComponentInstance;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.vehicle.wind_tunnel.WindTunnelJob;
import com.onewhohears.dscombat.init.DataSerializers;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetReloadListener;
import com.onewhohears.onewholibs.entity.JsonPresetEntity;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.UtilMCText;
import com.onewhohears.onewholibs.util.UtilParse;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityWindTunnel
extends JsonPresetEntity<VehicleStats> {
    public static final EntityDataAccessor<String> PRESET = SynchedEntityData.m_135353_(EntityWindTunnel.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Vec3> SPEED = SynchedEntityData.m_135353_(EntityWindTunnel.class, DataSerializers.VEC3);
    public static final EntityDataAccessor<Quaternion> Q = SynchedEntityData.m_135353_(EntityWindTunnel.class, DataSerializers.QUATERNION);
    public static final EntityDataAccessor<Float> THROTTLE = SynchedEntityData.m_135353_(EntityWindTunnel.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Boolean> AFTERBURNER = SynchedEntityData.m_135353_(EntityWindTunnel.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> HIDE_MODEL = SynchedEntityData.m_135353_(EntityWindTunnel.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Float> ALTITUDE = SynchedEntityData.m_135353_(EntityWindTunnel.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Vec3> INPUTS = SynchedEntityData.m_135353_(EntityWindTunnel.class, DataSerializers.VEC3);
    public static final EntityDataAccessor<CompoundTag> OVERRIDES = SynchedEntityData.m_135353_(EntityWindTunnel.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    @Nullable
    private EntityVehicle vehicle;
    @Nullable
    public WindTunnelJob job;
    public Vec3 totalAcc = Vec3.f_82478_;
    public Vec3 weightAcc = Vec3.f_82478_;
    public Vec3 thrustAcc = Vec3.f_82478_;
    public Vec3 dragAcc = Vec3.f_82478_;
    public Vec3 liftAcc = Vec3.f_82478_;
    public Vec3 rotAcc = Vec3.f_82478_;
    public double windCompAcc;
    public double centripetalAcc;
    public double yawRate;
    public double turnRadius;
    public final List<Float> aoas = new ArrayList<Float>();

    public EntityWindTunnel(EntityType<?> type, Level level) {
        super(type, level, "alexis_plane_unarmed");
        this.f_19794_ = true;
    }

    public void startFindMultiLiftDragJob(float altitude) {
        this.chatToNearbyPlayers("Starting Multi Find Lift/Drag Coefficients Job...", ChatFormatting.LIGHT_PURPLE);
        this.setQ(UtilAngles.toQuaternion((double)0.0, (double)0.0, (double)90.0));
        this.setThrottle(1.0f);
        this.setAfterBurner(true);
        this.setAltitude(altitude);
        this.setInputs(new Vec3(0.0, 0.0, 0.0));
        JsonArray array = new JsonArray();
        ListTag speeds = ((CompoundTag)this.f_19804_.m_135370_(OVERRIDES)).m_128437_("speeds", 6);
        ListTag aoas = ((CompoundTag)this.f_19804_.m_135370_(OVERRIDES)).m_128437_("aoas", 6);
        ListTag turn_rates = ((CompoundTag)this.f_19804_.m_135370_(OVERRIDES)).m_128437_("turn_rates", 6);
        if (aoas.size() != turn_rates.size() || aoas.size() != speeds.size()) {
            this.chatToNearbyPlayers("WARNING: Not all lists are the same length! aoas: " + aoas.size() + " speeds: " + speeds.size() + " turn_rates: " + turn_rates.size(), ChatFormatting.RED);
        }
        int l = Math.min(Math.min(aoas.size(), turn_rates.size()), speeds.size());
        for (int i = 0; i < l; ++i) {
            JsonObject data = new JsonObject();
            data.addProperty("speed", (Number)speeds.m_128772_(i));
            data.addProperty("aoa", (Number)aoas.m_128772_(i));
            data.addProperty("turn_rate", (Number)turn_rates.m_128772_(i));
            array.add((JsonElement)data);
        }
        this.job = new WindTunnelJob.MultiLiftDragJob(array);
    }

    public void setSpeedList(double[] speeds) {
        CompoundTag overrides = (CompoundTag)this.f_19804_.m_135370_(OVERRIDES);
        overrides.m_128365_("speeds", (Tag)EntityWindTunnel.doubleArrayToListTag(speeds));
        this.f_19804_.m_135381_(OVERRIDES, (Object)overrides);
    }

    public void setAOAList(double[] aoas) {
        CompoundTag overrides = (CompoundTag)this.f_19804_.m_135370_(OVERRIDES);
        overrides.m_128365_("aoas", (Tag)EntityWindTunnel.doubleArrayToListTag(aoas));
        this.f_19804_.m_135381_(OVERRIDES, (Object)overrides);
    }

    public void setTurnRateList(double[] turnRates) {
        CompoundTag overrides = (CompoundTag)this.f_19804_.m_135370_(OVERRIDES);
        overrides.m_128365_("turn_rates", (Tag)EntityWindTunnel.doubleArrayToListTag(turnRates));
        this.f_19804_.m_135381_(OVERRIDES, (Object)overrides);
    }

    public static ListTag doubleArrayToListTag(double[] a) {
        ListTag list = new ListTag();
        for (int i = 0; i < a.length; ++i) {
            list.m_7614_(i, (Tag)DoubleTag.m_128500_((double)a[i]));
        }
        return list;
    }

    public void startFindLiftDragJob(float speed, float turn_rate, float aoa, float altitude) {
        this.chatToNearbyPlayers("Starting Find Lift/Drag Coefficients Job...", ChatFormatting.LIGHT_PURPLE);
        this.chatToNearbyPlayers("Speed = " + speed + " | Turn Rate = " + turn_rate + " | AOA = " + aoa + " | Altitude = " + altitude, ChatFormatting.AQUA);
        this.setSpeed(new Vec3(0.0, 0.0, (double)speed));
        this.setQ(UtilAngles.toQuaternion((double)aoa, (double)0.0, (double)90.0));
        this.setThrottle(1.0f);
        this.setAfterBurner(true);
        this.setAltitude(altitude);
        this.setInputs(new Vec3(0.0, 0.0, 0.0));
        this.job = new WindTunnelJob.FindLiftDragJob(aoa, turn_rate);
    }

    public void setOverrideValue(String name, CompoundTag value) {
        CompoundTag overrides = (CompoundTag)this.f_19804_.m_135370_(OVERRIDES);
        overrides.m_128365_(name, (Tag)value);
        this.f_19804_.m_135381_(OVERRIDES, (Object)overrides);
    }

    public void clearOverrideValue(String name) {
        CompoundTag overrides = (CompoundTag)this.f_19804_.m_135370_(OVERRIDES);
        overrides.m_128473_(name);
        this.f_19804_.m_135381_(OVERRIDES, (Object)overrides);
    }

    public CompoundTag getOverrideValue(String name) {
        CompoundTag overrides = (CompoundTag)this.f_19804_.m_135370_(OVERRIDES);
        if (overrides.m_128441_(name)) {
            return overrides.m_128469_(name);
        }
        return null;
    }

    public void chatToNearbyPlayers(String msg) {
        this.chatToNearbyPlayers((Component)UtilMCText.literal((String)msg));
    }

    public void chatToNearbyPlayers(String msg, ChatFormatting color) {
        MutableComponent comp = UtilMCText.literal((String)msg);
        comp.m_6270_(Style.f_131099_.m_131140_(color));
        this.chatToNearbyPlayers((Component)comp);
    }

    public void chatToNearbyPlayers(Component msg) {
        AABB bb = this.m_20191_().m_82400_(16.0);
        for (Player player : this.m_9236_().m_6907_()) {
            if (!bb.m_82393_(player.m_20185_(), player.m_20186_(), player.m_20189_())) continue;
            player.m_5661_(msg, false);
        }
    }

    public void m_8119_() {
        if (!this.m_9236_().m_5776_() && this.job != null) {
            this.job.tick(this);
        }
        this.tickSimulate();
    }

    protected void tickSimulate() {
        Vec3 speed = this.getSpeed();
        Quaternion q = this.getQ();
        EntityVehicle vehicle = this.getSimulatedVehicle();
        vehicle.setTestMode(true);
        vehicle.m_146884_(this.m_20182_().m_82542_(1.0, 0.0, 1.0).m_82520_(0.0, (double)(this.getAltitude() + (float)UtilEntity.getSeaLevel((Level)this.m_9236_())), 0.0));
        vehicle.setQBySide(q);
        vehicle.m_20256_(speed);
        vehicle.setCurrentThrottle(this.getThrottle());
        vehicle.setUseAfterBurnerOverride(this.getAfterBurner());
        vehicle.tickPhysics();
        vehicle.updateEulerAngles();
        vehicle.setLandingGear(false);
        vehicle.foldLandingGearNow();
        if (this.m_9236_().m_5776_()) {
            vehicle.clientTick();
        }
        Vec3 i = this.getInputs();
        vehicle.inputs.pitch = (float)i.f_82479_;
        vehicle.inputs.yaw = (float)i.f_82480_;
        vehicle.inputs.roll = (float)i.f_82481_;
        this.totalAcc = vehicle.getAccFromForce(vehicle.getForces());
        this.weightAcc = vehicle.getAccFromForce(vehicle.getWeightForce());
        this.thrustAcc = vehicle.getAccFromForce(vehicle.getThrustForce(q));
        this.dragAcc = vehicle.getAccFromForce(vehicle.getDragForce(q));
        this.liftAcc = Vec3.f_82478_;
        this.aoas.clear();
        for (PhysicsComponentInstance<?> phy : vehicle.getPhysicsInstances()) {
            this.dragAcc = this.dragAcc.m_82549_(vehicle.getAccFromForce(phy.getDragForce()));
            this.liftAcc = this.liftAcc.m_82549_(vehicle.getAccFromForce(phy.getLiftForce()));
            this.aoas.add(Float.valueOf(phy.getAOA()));
        }
        this.windCompAcc = UtilGeometry.vecCompMagDirByAxis((Vec3)this.totalAcc, (Vec3)speed);
        Vec3 cenAxis = UtilAngles.getRollAxis((double)0.0, (double)((vehicle.m_146908_() + 90.0f) * ((float)Math.PI / 180)));
        this.centripetalAcc = UtilGeometry.vecCompMagDirByNormAxis((Vec3)this.liftAcc, (Vec3)cenAxis);
        this.yawRate = this.centripetalAcc / (double)vehicle.getXZSpeed() * 57.2957763671875;
        this.turnRadius = (double)vehicle.getXZSpeed() / (this.yawRate * 0.01745329238474369);
        Vec3 m = vehicle.getMoment();
        Vec3 I = vehicle.getTotalRotInertia();
        this.rotAcc = new Vec3(m.f_82479_ / I.f_82479_, m.f_82480_ / I.f_82480_, m.f_82481_ / I.f_82481_).m_82490_(vehicle.getAccTimeScale());
    }

    @NotNull
    public EntityVehicle getSimulatedVehicle() {
        if (this.vehicle == null || this.getStatsHolder().getHolderReloads() != this.getPresets().getReloads() || !this.vehicle.getStatsId().equals(this.getStatsId())) {
            this.vehicle = this.createVehicleToSimulate();
        }
        return this.vehicle;
    }

    private EntityVehicle createVehicleToSimulate() {
        this.verifyCurrentPresetId();
        VehicleStats stats = (VehicleStats)this.getStats();
        EntityType<? extends EntityVehicle> entityType = stats.getEntityType();
        EntityVehicle vehicle = (EntityVehicle)entityType.m_20615_(this.m_9236_());
        vehicle.setPreset(this.getStatsId());
        vehicle.updatePhysicsInstances();
        vehicle.partsManager.read(stats.getDataAsNBT(), stats.getDataAsNBT());
        if (this.m_9236_().m_5776_()) {
            vehicle.partsManager.clientPartsSetup();
            vehicle.textureManager.setupTextureLocations();
            vehicle.textureManager.setupDynamicTexture();
        } else {
            vehicle.partsManager.setupParts();
        }
        for (PhysicsComponentInstance<?> phy : vehicle.getPhysicsInstances()) {
            phy.setWindTunnel(this);
        }
        return vehicle;
    }

    public void verifyCurrentPresetId() {
        if (!VehiclePresets.get().has(this.getStatsId())) {
            this.setPreset("wooden_plane");
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SPEED, (Object)Vec3.f_82478_);
        this.f_19804_.m_135372_(Q, (Object)Quaternion.f_80118_);
        this.f_19804_.m_135372_(THROTTLE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(AFTERBURNER, (Object)false);
        this.f_19804_.m_135372_(HIDE_MODEL, (Object)false);
        this.f_19804_.m_135372_(ALTITUDE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(INPUTS, (Object)Vec3.f_82478_);
        this.f_19804_.m_135372_(OVERRIDES, (Object)new CompoundTag());
        this.f_19804_.m_135372_(PRESET, (Object)"wooden_plane");
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> key) {
        String sync;
        if (key.equals(PRESET) && !(sync = (String)this.f_19804_.m_135370_(PRESET)).equals(this.getStatsId())) {
            this.setPreset(sync);
        }
    }

    public void setPreset(@NotNull String preset) {
        super.setPreset(preset);
        this.f_19804_.m_135381_(PRESET, (Object)preset);
    }

    @NotNull
    public JsonPresetReloadListener<VehicleStats> getPresets() {
        return VehiclePresets.get();
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.verifyCurrentPresetId();
        this.f_19804_.m_135381_(PRESET, (Object)this.getStatsId());
        this.setSpeed(UtilParse.readVec3((CompoundTag)tag, (String)"speed"));
        float qi = tag.m_128457_("qi");
        float qj = tag.m_128457_("qj");
        float qk = tag.m_128457_("qk");
        float qr = tag.m_128457_("qr");
        this.setQ(new Quaternion(qi, qj, qk, qr));
        this.setThrottle(tag.m_128457_("throttle"));
        this.setAfterBurner(tag.m_128471_("afterburner"));
        this.setHideModel(tag.m_128471_("hide_model"));
        this.setAltitude(tag.m_128457_("altitude"));
        this.setInputs(UtilParse.readVec3((CompoundTag)tag, (String)"inputs"));
        this.f_19804_.m_135381_(OVERRIDES, (Object)tag.m_128469_("overrides"));
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        UtilParse.writeVec3((CompoundTag)tag, (Vec3)this.getSpeed(), (String)"speed");
        Quaternion q = this.getQ();
        tag.m_128350_("qi", q.m_80140_());
        tag.m_128350_("qj", q.m_80150_());
        tag.m_128350_("qk", q.m_80153_());
        tag.m_128350_("qr", q.m_80156_());
        tag.m_128350_("throttle", this.getThrottle());
        tag.m_128379_("afterburner", this.getAfterBurner());
        tag.m_128379_("hide_model", this.getHideModel());
        tag.m_128350_("altitude", this.getAltitude());
        UtilParse.writeVec3((CompoundTag)tag, (Vec3)this.getInputs(), (String)"inputs");
        tag.m_128365_("overrides", (Tag)this.f_19804_.m_135370_(OVERRIDES));
    }

    public Vec3 getSpeed() {
        return (Vec3)this.f_19804_.m_135370_(SPEED);
    }

    public void setSpeed(Vec3 speed) {
        this.f_19804_.m_135381_(SPEED, (Object)speed);
    }

    public Quaternion getQ() {
        return (Quaternion)this.f_19804_.m_135370_(Q);
    }

    public void setQ(Quaternion q) {
        this.f_19804_.m_135381_(Q, (Object)q);
    }

    public float getThrottle() {
        return ((Float)this.f_19804_.m_135370_(THROTTLE)).floatValue();
    }

    public void setThrottle(float throttle) {
        this.f_19804_.m_135381_(THROTTLE, (Object)Float.valueOf(throttle));
    }

    public boolean getAfterBurner() {
        return (Boolean)this.f_19804_.m_135370_(AFTERBURNER);
    }

    public void setAfterBurner(boolean enable) {
        this.f_19804_.m_135381_(AFTERBURNER, (Object)enable);
    }

    public boolean getHideModel() {
        return (Boolean)this.f_19804_.m_135370_(HIDE_MODEL);
    }

    public void setHideModel(boolean enable) {
        this.f_19804_.m_135381_(HIDE_MODEL, (Object)enable);
    }

    public float getAltitude() {
        return ((Float)this.f_19804_.m_135370_(ALTITUDE)).floatValue();
    }

    public void setAltitude(float alt) {
        this.f_19804_.m_135381_(ALTITUDE, (Object)Float.valueOf(alt));
    }

    public Vec3 getInputs() {
        return (Vec3)this.f_19804_.m_135370_(INPUTS);
    }

    public void setInputs(Vec3 inputs) {
        this.f_19804_.m_135381_(INPUTS, (Object)inputs);
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

