/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.entity.weapon;

import com.onewhohears.dscombat.command.DSCGameRules;
import com.onewhohears.dscombat.common.network.PacketHandler;
import com.onewhohears.dscombat.common.network.toclient.ToClientWeaponImpact;
import com.onewhohears.dscombat.data.weapon.WeaponPresets;
import com.onewhohears.dscombat.data.weapon.WeaponType;
import com.onewhohears.dscombat.data.weapon.client.WeaponAssets;
import com.onewhohears.dscombat.data.weapon.client.WeaponClientStats;
import com.onewhohears.dscombat.data.weapon.stats.WeaponStats;
import com.onewhohears.dscombat.entity.damagesource.WeaponDamageSource;
import com.onewhohears.dscombat.init.DataSerializers;
import com.onewhohears.dscombat.init.ModTags;
import com.onewhohears.dscombat.util.UtilVehicleEntity;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetAssetReader;
import com.onewhohears.onewholibs.data.jsonpreset.JsonPresetReloadListener;
import com.onewhohears.onewholibs.entity.CustomAnimProjectile;
import com.onewhohears.onewholibs.util.UtilEntity;
import com.onewhohears.onewholibs.util.UtilParse;
import com.onewhohears.onewholibs.util.math.UtilAngles;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public abstract class EntityWeapon<T extends WeaponStats>
extends CustomAnimProjectile<T, WeaponClientStats>
implements IEntityAdditionalSpawnData {
    public static final EntityDataAccessor<Integer> OWNER_ID = SynchedEntityData.m_135353_(EntityWeapon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> AGE = SynchedEntityData.m_135353_(EntityWeapon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> TEST_MODE = SynchedEntityData.m_135353_(EntityWeapon.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Vec3> SHOOT_POS = SynchedEntityData.m_135353_(EntityWeapon.class, DataSerializers.VEC3);

    public EntityWeapon(EntityType<? extends EntityWeapon<?>> type, Level level, String defaultWeaponId) {
        super(type, level, defaultWeaponId);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(OWNER_ID, (Object)-1);
        this.f_19804_.m_135372_(AGE, (Object)0);
        this.f_19804_.m_135372_(TEST_MODE, (Object)false);
        this.f_19804_.m_135372_(SHOOT_POS, (Object)Vec3.f_82478_);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (this.f_19853_.f_46443_ && key.equals(AGE)) {
            this.f_19797_ = (Integer)this.f_19804_.m_135370_(AGE);
        }
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19797_ = compound.m_128451_("tickCount");
        if (this.m_37282_() != null) {
            this.setOwnerId(this.m_37282_().m_19879_());
        } else {
            this.setOwnerId(-1);
        }
        this.setTestMode(compound.m_128471_("test_mode"));
        this.setShootPos(UtilParse.readVec3((CompoundTag)compound, (String)"shoot_pos"));
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("tickCount", this.f_19797_);
        compound.m_128379_("test_mode", this.isTestMode());
        UtilParse.writeVec3((CompoundTag)compound, (Vec3)this.getShootPos(), (String)"shoot_pos");
    }

    public T getWeaponStats() {
        return (T)((Object)((WeaponStats)this.getStats()));
    }

    public void init() {
    }

    public void m_8119_() {
        if (this.isTestMode()) {
            return;
        }
        if (this.f_19803_) {
            this.init();
        }
        if (!this.f_19853_.f_46443_ && this.f_19803_) {
            this.setShootPos(this.m_20182_());
        }
        super.m_8119_();
        this.tickCheckCollide();
        this.tickSetMove();
        this.tickSetAngle();
        this.m_146884_(this.m_20182_().m_82549_(this.m_20184_()));
        this.m_20101_();
        this.tickAge();
    }

    protected void tickAge() {
        if (!this.f_19853_.f_46443_) {
            this.setAge(this.f_19797_);
            if (this.f_19797_ > this.getMaxAge()) {
                this.m_6074_();
            }
        }
    }

    public ClipContext.Fluid getFluidClipContext() {
        return ClipContext.Fluid.NONE;
    }

    protected void tickCheckCollide() {
        Vec3 move = this.m_20184_();
        Vec3 pos = this.m_20182_();
        Vec3 next_pos = pos.m_82549_(move);
        BlockHitResult hitresult = this.checkBlockCollide();
        if (hitresult.m_6662_() != HitResult.Type.MISS) {
            next_pos = hitresult.m_82450_();
        }
        Entity owner = this.m_37282_();
        while (!this.m_213877_()) {
            Entity hit;
            EntityHitResult entityhitresult = this.findHitEntity(pos, next_pos);
            if (entityhitresult != null) {
                hitresult = entityhitresult;
            }
            if (owner != null && hitresult != null && hitresult.m_6662_() == HitResult.Type.ENTITY && this.shouldSkipCollide(hit = ((EntityHitResult)hitresult).m_82443_(), owner)) {
                hitresult = null;
                entityhitresult = null;
            }
            if (hitresult != null && hitresult.m_6662_() != HitResult.Type.MISS && !this.f_19794_ && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                this.m_6532_((HitResult)hitresult);
                this.f_19812_ = true;
                break;
            }
            if (entityhitresult == null) break;
            hitresult = null;
        }
    }

    private boolean shouldSkipCollide(Entity hit, Entity owner) {
        return this.m_9236_().m_5776_() != hit.m_9236_().m_5776_() || hit.m_7307_(owner);
    }

    protected BlockHitResult checkBlockCollide() {
        return this.f_19853_.m_45547_(new ClipContext(this.m_20182_(), this.m_20182_().m_82549_(this.m_20184_()), ClipContext.Block.COLLIDER, this.getFluidClipContext(), (Entity)this));
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 start, Vec3 end) {
        return UtilEntity.getEntityHitResultAtClip((Level)this.f_19853_, (Entity)this, (Vec3)start, (Vec3)end, (AABB)this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), this::m_5603_, (float)0.3f);
    }

    public boolean m_5603_(Entity entity) {
        return super.m_5603_(entity) && !this.m_7307_(entity);
    }

    public void m_6532_(HitResult result) {
        if (this.m_213877_()) {
            return;
        }
        this.m_146884_(result.m_82450_());
        super.m_6532_(result);
    }

    public void m_8060_(BlockHitResult result) {
        BlockState state;
        super.m_8060_(result);
        if (this.canBreakFragileBlocks() && (state = this.m_9236_().m_8055_(result.m_82425_())).m_204336_(ModTags.Blocks.FRAGILE) && this.m_9236_().m_46469_().m_46207_(DSCGameRules.WEAPONS_BREAK_BLOCKS) && UtilVehicleEntity.weaponHasPermissionToBreak(result.m_82425_(), state, this.m_9236_(), this.m_37282_())) {
            this.m_9236_().m_46953_(result.m_82425_(), true, (Entity)this);
            return;
        }
        this.m_6074_();
    }

    public void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        this.m_6074_();
        result.m_82443_().m_6469_((DamageSource)this.getImpactDamageSource(), this.getDamage());
    }

    public void m_6074_() {
        if (!this.f_19853_.f_46443_) {
            PacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new ToClientWeaponImpact(this, this.m_20182_()));
        }
        super.m_6074_();
    }

    public float getDamage() {
        return 0.0f;
    }

    protected int getOwnerId() {
        return (Integer)this.f_19804_.m_135370_(OWNER_ID);
    }

    protected void setOwnerId(int id) {
        this.f_19804_.m_135381_(OWNER_ID, (Object)id);
    }

    protected void setAge(int age) {
        this.f_19804_.m_135381_(AGE, (Object)age);
    }

    public int getAge() {
        if (!this.f_19853_.f_46443_) {
            return this.f_19797_;
        }
        return (Integer)this.f_19804_.m_135370_(AGE);
    }

    public boolean m_6128_() {
        return true;
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6783_(double dist) {
        return dist < 65536.0;
    }

    protected void tickSetMove() {
        this.m_20256_(this.m_20184_().m_82520_(0.0, -this.getGravityAcc(), 0.0));
    }

    protected double getGravityAcc() {
        return 0.024525;
    }

    protected void tickSetAngle() {
        float goalPitch = UtilAngles.getPitch((Vec3)this.m_20184_());
        float goalYaw = UtilAngles.getYaw((Vec3)this.m_20184_());
        this.m_146926_(Mth.m_14189_((float)0.5f, (float)this.m_146909_(), (float)goalPitch));
        this.m_146922_(Mth.m_14189_((float)0.5f, (float)this.m_146908_(), (float)goalYaw));
    }

    public void m_6001_(double x, double y, double z) {
    }

    public Entity m_37282_() {
        Entity o = super.m_37282_();
        if (o == null && this.f_19853_.f_46443_) {
            Minecraft m = Minecraft.m_91087_();
            o = m.f_91073_.m_6815_(this.getOwnerId());
        }
        return o;
    }

    public void m_5602_(Entity owner) {
        super.m_5602_(owner);
        if (owner != null) {
            this.setOwnerId(owner.m_19879_());
        } else {
            this.setOwnerId(-1);
        }
    }

    public boolean m_7307_(Entity entity) {
        Projectile p;
        Entity po;
        if (entity == null) {
            return false;
        }
        Entity o = this.m_37282_();
        if (entity.equals((Object)o)) {
            return true;
        }
        if (entity instanceof Projectile && (po = (p = (Projectile)entity).m_37282_()) != null && po.equals((Object)o)) {
            return true;
        }
        Entity c = entity.m_6688_();
        if (c != null) {
            if (c.equals((Object)o)) {
                return true;
            }
            return this.m_20031_(c.m_5647_());
        }
        return super.m_7307_(entity);
    }

    public boolean m_20031_(Team team) {
        if (team == null) {
            return false;
        }
        Entity o = this.m_37282_();
        if (o != null) {
            return team.m_83536_(o.m_5647_());
        }
        return super.m_20031_(team);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
    }

    public void m_6043_() {
        if (this.isTestMode()) {
            return;
        }
        if (!this.f_19853_.f_46443_ && !this.inEntityTickingRange()) {
            this.m_146870_();
            return;
        }
    }

    public boolean inEntityTickingRange() {
        if (this.f_19853_.f_46443_) {
            return true;
        }
        ServerLevel sl = (ServerLevel)this.f_19853_;
        ServerChunkCache scc = sl.m_7726_();
        return scc.f_8325_.m_143145_().m_183913_(this.m_146902_().m_45588_());
    }

    public int getMaxAge() {
        return ((WeaponStats)((Object)this.getWeaponStats())).getMaxAge();
    }

    public boolean isTestMode() {
        return (Boolean)this.f_19804_.m_135370_(TEST_MODE);
    }

    public void setTestMode(boolean testMode) {
        this.f_19804_.m_135381_(TEST_MODE, (Object)testMode);
    }

    public Vec3 getShootPos() {
        return (Vec3)this.f_19804_.m_135370_(SHOOT_POS);
    }

    private void setShootPos(Vec3 pos) {
        this.f_19804_.m_135381_(SHOOT_POS, (Object)pos);
    }

    public String getModelId() {
        if (this.getAssets() == null) {
            return this.getAssetId();
        }
        return ((WeaponClientStats)this.getAssets()).getModelId();
    }

    public abstract WeaponType getWeaponType();

    protected abstract WeaponDamageSource getImpactDamageSource();

    protected abstract WeaponDamageSource getExplosionDamageSource();

    public abstract WeaponStats.WeaponClientImpactType getClientImpactType();

    public boolean canBreakFragileBlocks() {
        return true;
    }

    @Nullable
    public String getAssetId() {
        return ((WeaponStats)this.getStats()).getAssetId();
    }

    @Nullable
    public JsonPresetAssetReader<WeaponClientStats> getClientPresets() {
        if (!this.m_9236_().m_5776_()) {
            return null;
        }
        return WeaponAssets.get();
    }

    @NotNull
    public JsonPresetReloadListener<T> getPresets() {
        return WeaponPresets.get();
    }

    public boolean isDiscardedButTicking() {
        return false;
    }
}

