/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.item;

import com.onewhohears.dscombat.data.parts.PartPresets;
import com.onewhohears.dscombat.data.parts.instance.PartInstance;
import com.onewhohears.dscombat.data.parts.stats.PartStats;
import com.onewhohears.dscombat.init.ModItems;
import com.onewhohears.dscombat.item.ItemVehicle;
import com.onewhohears.dscombat.util.UtilPresetParse;
import com.onewhohears.onewholibs.util.UtilItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemPart
extends Item {
    @NotNull
    private String defaultPresetId = "";

    public ItemPart(int stackSize, @NotNull String defaultPresetId) {
        this(ItemPart.partProps(stackSize), defaultPresetId);
    }

    public ItemPart(Item.Properties props, @NotNull String defaultPresetId) {
        super(props);
        this.defaultPresetId = defaultPresetId;
    }

    public ItemPart(int stackSize) {
        super(ItemPart.partProps(stackSize));
    }

    public ItemPart(Item.Properties props) {
        super(props);
    }

    public static Item.Properties partProps(int stackSize) {
        return new Item.Properties().m_41491_(ModItems.PARTS).m_41487_(stackSize);
    }

    public static Item.Properties itemProps(int stackSize) {
        return new Item.Properties().m_41491_(ModItems.DSC_ITEMS).m_41487_(stackSize);
    }

    public void m_6787_(@NotNull CreativeModeTab group, @NotNull NonNullList<ItemStack> items) {
        if (group != this.getCreativeTab() && group != CreativeModeTab.f_40754_) {
            return;
        }
        String itemId = UtilItem.getItemKeyString((Item)this);
        for (int i = 0; i < PartPresets.get().getNum(); ++i) {
            PartStats stats = ((PartStats[])PartPresets.get().getAll())[i];
            if (!stats.getItemId().equals(itemId)) continue;
            this.fillItemCategory(stats, items);
        }
    }

    protected void fillItemCategory(PartStats stats, NonNullList<ItemStack> items) {
        items.add((Object)stats.createFilledPartInstance("").getNewItemStack());
    }

    public CreativeModeTab getCreativeTab() {
        return ModItems.PARTS;
    }

    @Nullable
    public PartStats getDefaultPartStats() {
        return (PartStats)PartPresets.get().get(this.getDefaultPartPresetId());
    }

    public String getDefaultPartPresetId() {
        if (this.defaultPresetId.isEmpty()) {
            this.defaultPresetId = this.toString();
        }
        return this.defaultPresetId;
    }

    @NotNull
    public ItemStack m_7968_() {
        ItemStack stack = new ItemStack((ItemLike)this);
        PartStats stats = this.getDefaultPartStats();
        if (stats != null) {
            stack.m_41751_(stats.createPartInstance().writeNBT());
        }
        return stack;
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        PartInstance<?> instance = this.getPartInstance(stack);
        if (instance != null) {
            return instance.getItemName();
        }
        return super.m_7626_(stack);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tips, @NotNull TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tips, isAdvanced);
        PartInstance<?> instance = this.getPartInstance(stack);
        if (instance != null) {
            instance.addToolTips(tips, isAdvanced);
            if (isAdvanced.m_7050_()) {
                tips.add(ItemVehicle.formatTooltip("PartId", instance.getStatsId()));
            }
        }
    }

    @Nullable
    public PartInstance<?> getPartInstance(ItemStack stack) {
        return UtilPresetParse.parsePartFromItem(stack, this.getDefaultPartPresetId());
    }

    @NotNull
    public String getPreset(@NotNull ItemStack stack) {
        PartStats stats = UtilPresetParse.getPartStatsFromItem(stack);
        if (stats == null) {
            return this.getDefaultPartPresetId();
        }
        return stats.getId();
    }
}

