/*
 * Decompiled with CFR 0.152.
 */
package com.onewhohears.dscombat.util;

import com.mojang.logging.LogUtils;
import com.onewhohears.dscombat.client.sounds.AfterBurnerSoundInstance;
import com.onewhohears.dscombat.client.sounds.DopplerSoundInstance;
import com.onewhohears.dscombat.client.sounds.PlaneMusicSoundInstance;
import com.onewhohears.dscombat.client.sounds.VehicleEngineSoundInstance;
import com.onewhohears.dscombat.client.sounds.VehicleWindSoundInstance;
import com.onewhohears.dscombat.data.vehicle.physics.DSCPhyCons;
import com.onewhohears.dscombat.data.vehicle.stats.VehicleStats;
import com.onewhohears.dscombat.data.weapon.stats.MissileStats;
import com.onewhohears.dscombat.entity.vehicle.EntityVehicle;
import com.onewhohears.dscombat.entity.weapon.EntityMissile;
import com.onewhohears.dscombat.init.ModSounds;
import com.onewhohears.dscombat.util.UtilSound;
import com.onewhohears.onewholibs.util.math.UtilGeometry;
import java.util.NoSuchElementException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class UtilClientSafeSounds {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static long prevQueueTime = 0L;
    private static int waitTime = 0;

    public static void dopplerSound(Entity entity, SoundEvent sound, float initVolume, float initPitch, float velSound, boolean delayed) {
        Minecraft m = Minecraft.m_91087_();
        LocalPlayer p = m.f_91074_;
        if (p == null) {
            return;
        }
        int delay = 0;
        if (delayed) {
            delay = (int)(p.m_20270_(entity) / velSound);
        }
        m.m_91106_().m_120369_((SoundInstance)new DopplerSoundInstance(sound, p, entity, initVolume, initPitch, velSound), delay);
    }

    public static void nonPassengerVehicleEngineSound(EntityVehicle plane, SoundEvent sound, double range) {
        Minecraft m = Minecraft.m_91087_();
        LocalPlayer p = m.f_91074_;
        if (p == null) {
            return;
        }
        m.m_91106_().m_120367_((SoundInstance)new VehicleEngineSoundInstance(sound, p, plane, DSCPhyCons.VEL_SOUND, false, range, 0.0f));
    }

    public static void nonPassengerVehicleEngineSound(EntityVehicle plane, SoundEvent sound) {
        Minecraft m = Minecraft.m_91087_();
        LocalPlayer p = m.f_91074_;
        if (p == null) {
            return;
        }
        m.m_91106_().m_120367_((SoundInstance)new VehicleEngineSoundInstance(sound, p, plane, DSCPhyCons.VEL_SOUND, false));
    }

    public static void passengerVehicleEngineSound(EntityVehicle plane, SoundEvent sound) {
        Minecraft m = Minecraft.m_91087_();
        LocalPlayer p = m.f_91074_;
        if (p == null) {
            return;
        }
        m.m_91106_().m_120367_((SoundInstance)new VehicleEngineSoundInstance(sound, p, plane, DSCPhyCons.VEL_SOUND, true));
    }

    public static void nonPassengerAfterBurnerSound(EntityVehicle plane, SoundEvent sound, double range, float minDist) {
        Minecraft m = Minecraft.m_91087_();
        LocalPlayer p = m.f_91074_;
        if (p == null) {
            return;
        }
        m.m_91106_().m_120367_((SoundInstance)new AfterBurnerSoundInstance(sound, p, plane, DSCPhyCons.VEL_SOUND, false, range, minDist));
    }

    public static void passengerAfterBurnerSound(EntityVehicle plane, SoundEvent sound) {
        Minecraft m = Minecraft.m_91087_();
        LocalPlayer p = m.f_91074_;
        if (p == null) {
            return;
        }
        m.m_91106_().m_120367_((SoundInstance)new AfterBurnerSoundInstance(sound, p, plane, DSCPhyCons.VEL_SOUND, true));
    }

    public static void nonPassengerWindSound(EntityVehicle plane, SoundEvent sound, double range, float minDist) {
        Minecraft m = Minecraft.m_91087_();
        LocalPlayer p = m.f_91074_;
        if (p == null) {
            return;
        }
        m.m_91106_().m_120367_((SoundInstance)new VehicleWindSoundInstance(sound, p, plane, DSCPhyCons.VEL_SOUND, false, range, minDist, 0.0));
    }

    public static void passengerWindSound(EntityVehicle plane, SoundEvent sound, double minSpeed) {
        Minecraft m = Minecraft.m_91087_();
        LocalPlayer p = m.f_91074_;
        if (p == null) {
            return;
        }
        m.m_91106_().m_120367_((SoundInstance)new VehicleWindSoundInstance(sound, p, plane, DSCPhyCons.VEL_SOUND, true, minSpeed));
    }

    public static void aircraftRadio(EntityVehicle plane, SoundEvent sound) {
        Minecraft m = Minecraft.m_91087_();
        LocalPlayer p = m.f_91074_;
        if (p == null) {
            return;
        }
        m.m_91106_().m_120367_((SoundInstance)new PlaneMusicSoundInstance(sound, p, plane, DSCPhyCons.VEL_SOUND));
    }

    public static void aircraftRadio(EntityVehicle plane, String sound) {
        try {
            SoundEvent se = UtilSound.getSoundById(sound, SoundEvents.f_12086_);
            UtilClientSafeSounds.aircraftRadio(plane, se);
        }
        catch (NoSuchElementException e) {
            LOGGER.error("ERROR: " + sound + " does not exist!");
        }
    }

    public static void playCockpitSound(RegistryObject<SoundEvent> sound, float pitch, float volume) {
        if (sound == null) {
            return;
        }
        UtilClientSafeSounds.playCockpitSound((SoundEvent)sound.get(), pitch, volume);
    }

    public static void playCockpitSound(SoundEvent sound, float pitch, float volume) {
        if (sound == null) {
            return;
        }
        Minecraft m = Minecraft.m_91087_();
        m.m_91106_().m_120367_((SoundInstance)UtilClientSafeSounds.forCockpit(sound, pitch, volume));
    }

    public static void queueCockpitSound(SoundEvent sound, float pitch, float volume, int length) {
        if (sound == null) {
            return;
        }
        Minecraft m = Minecraft.m_91087_();
        long currentTime = m.f_91073_.m_46467_();
        long timeDiff = currentTime - prevQueueTime;
        if ((waitTime = (int)((long)waitTime - timeDiff)) < 0) {
            waitTime = 0;
        }
        m.m_91106_().m_120369_((SoundInstance)UtilClientSafeSounds.forCockpit(sound, pitch, volume), waitTime);
        waitTime += length;
        prevQueueTime = currentTime;
    }

    public static SimpleSoundInstance forCockpit(SoundEvent sound, float pitch, float volume) {
        if (sound == null) {
            sound = SoundEvents.f_12509_;
        }
        final Minecraft m = Minecraft.m_91087_();
        final int vehicleId = m.f_91074_.m_20201_().m_19879_();
        return new SimpleSoundInstance(sound.m_11660_(), SoundSource.PLAYERS, volume, pitch, SoundInstance.m_235150_(), false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true){

            public float m_7769_() {
                if (m.f_91074_ != null && m.f_91074_.m_20159_() && m.f_91074_.m_20201_().m_19879_() == vehicleId) {
                    return super.m_7769_();
                }
                return 0.0f;
            }
        };
    }

    public static boolean isClientRidingVehicle(EntityVehicle vehicle) {
        Minecraft m = Minecraft.m_91087_();
        if (m.f_91074_ == null) {
            return false;
        }
        return m.f_91074_.m_20201_().equals((Object)vehicle);
    }

    public static boolean missileSonicBoom(@NotNull EntityMissile<?> missile) {
        return UtilClientSafeSounds.entitySonicBoom(missile, ((MissileStats)missile.getStats()).getMass());
    }

    public static boolean vehicleSonicBoom(@NotNull EntityVehicle vehicle) {
        return UtilClientSafeSounds.entitySonicBoom((Entity)vehicle, ((VehicleStats)vehicle.getStats()).mass);
    }

    public static boolean entitySonicBoom(@NotNull Entity entity, float mass) {
        if (UtilGeometry.isZero((Vec3)entity.m_20184_())) {
            return false;
        }
        Minecraft m = Minecraft.m_91087_();
        if (m.f_91074_ == null) {
            return false;
        }
        float size = mass / 8573.0f;
        float pitch = UtilClientSafeSounds.getSonicBoomPitch((Entity)m.f_91074_, entity, DSCPhyCons.VEL_SOUND, size);
        if (pitch <= 0.0f) {
            return false;
        }
        Vec3 diff = entity.m_20182_().m_82546_(m.f_91074_.m_20182_());
        double distance = diff.m_82553_();
        double scale = Math.max(1.0, Math.min(32.0, distance * 0.08));
        Vec3 pos = m.f_91074_.m_20182_().m_82549_(diff.m_82541_().m_82490_(scale));
        float volume = Math.max(0.0f, Math.min(1.0f, 400.0f / (float)distance));
        m.f_91074_.m_9236_().m_7785_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), ModSounds.SONIC_BOOM, SoundSource.PLAYERS, volume, pitch, false);
        return true;
    }

    public static float getSonicBoomPitch(@NotNull Entity observer, @NotNull Entity aircraft, double speedOfSound, double aircraftSize) {
        Vec3 aircraftPos = aircraft.m_20182_();
        Vec3 observerPos = observer.m_20182_();
        Vec3 velocity = aircraft.m_20184_();
        double aircraftSpeed = velocity.m_82553_();
        if (aircraftSpeed <= speedOfSound) {
            return -1.0f;
        }
        Vec3 toObserver = observerPos.m_82546_(aircraftPos);
        if (toObserver.m_82526_(velocity) >= 0.0) {
            return -1.0f;
        }
        double normalizedSize = Math.max(aircraftSize, 0.01);
        double pitch = 1.0 / normalizedSize;
        pitch = Math.max(0.9, Math.min(pitch, 4.0));
        return (float)pitch;
    }
}

