/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.capability.entity.IEntityTravelersBackpack;
import com.tiviacz.travelersbackpack.client.model.TravelersBackpackWearableModel;
import com.tiviacz.travelersbackpack.client.renderer.TravelersBackpackBlockEntityRenderer;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.util.ResourceUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TravelersBackpackEntityLayer
extends RenderLayer<LivingEntity, HumanoidModel<LivingEntity>> {
    public TravelersBackpackWearableModel model;

    public TravelersBackpackEntityLayer(RenderLayerParent<LivingEntity, HumanoidModel<LivingEntity>> renderer) {
        super(renderer);
    }

    public void render(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, LivingEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        if (TravelersBackpackConfig.disableBackpackRender) {
            return;
        }
        if (CapabilityUtils.isWearingBackpack(pLivingEntity) && !pLivingEntity.m_20145_()) {
            this.renderLayer(pPoseStack, pBuffer, pPackedLight, pLivingEntity, pLimbSwing, pLimbSwingAmount, pPartialTick, pAgeInTicks, pNetHeadYaw, pHeadPitch);
        }
    }

    private void renderLayer(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack stack = ((IEntityTravelersBackpack)CapabilityUtils.getEntityCapability(livingEntity).resolve().get()).getWearable();
        this.model = new TravelersBackpackWearableModel(livingEntity, bufferIn, TravelersBackpackBlockEntityRenderer.createTravelersBackpack(true).m_171564_());
        boolean flag = stack.m_41720_() == ModItems.QUARTZ_TRAVELERS_BACKPACK.get() || stack.m_41720_() == ModItems.SNOW_TRAVELERS_BACKPACK.get();
        boolean isCustomSleepingBag = false;
        ResourceLocation loc = ResourceUtils.getBackpackTexture(stack.m_41720_());
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("SleepingBagColor")) {
            isCustomSleepingBag = true;
        }
        VertexConsumer vertexConsumer = bufferIn.m_6299_(flag ? RenderType.m_110470_((ResourceLocation)loc) : RenderType.m_110446_((ResourceLocation)loc));
        poseStack.m_85836_();
        if (livingEntity.m_6047_()) {
            poseStack.m_85837_(0.0, -0.155, 0.025);
        }
        if (livingEntity.m_6162_()) {
            poseStack.m_85837_(0.0, 0.65, 0.0);
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        }
        ((HumanoidModel)this.m_117386_()).m_102872_((HumanoidModel)this.model);
        this.model.setupAngles((HumanoidModel)this.m_117386_());
        poseStack.m_85837_(0.0, 0.175, 0.325);
        poseStack.m_85841_(0.85f, 0.85f, 0.85f);
        this.model.m_7695_(poseStack, vertexConsumer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        loc = isCustomSleepingBag ? ResourceUtils.getSleepingBagTexture(stack.m_41784_().m_128451_("SleepingBagColor")) : ResourceUtils.getDefaultSleepingBagTexture();
        vertexConsumer = bufferIn.m_6299_(RenderType.m_110452_((ResourceLocation)loc));
        this.model.m_7695_(poseStack, vertexConsumer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.25f);
        poseStack.m_85849_();
    }
}

